/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.LineEndings;
import org.apache.maven.plugin.assembly.utils.LineEndingsUtils;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderFormatter {
    private static Reader createReaderFilter(@Nonnull Reader source, String sourceName, String encoding, String escapeString, List<String> delimiters, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        try {
            boolean isPropertiesFile = AssemblyFileUtils.isPropertyFile(sourceName);
            MavenReaderFilterRequest filterRequest = new MavenReaderFilterRequest(source, true, configSource.getProject(), configSource.getFilters(), isPropertiesFile, encoding, configSource.getMavenSession(), null);
            filterRequest.setEscapeString(escapeString);
            if (delimiters != null && !delimiters.isEmpty()) {
                LinkedHashSet<String> delims = new LinkedHashSet<String>();
                for (String delim : delimiters) {
                    if (delim == null) {
                        delims.add("${*}");
                        continue;
                    }
                    delims.add(delim);
                }
                filterRequest.setDelimiters(delims);
            } else {
                filterRequest.setDelimiters(filterRequest.getDelimiters());
            }
            filterRequest.setInjectProjectBuildFilters(configSource.isIncludeProjectBuildFilters());
            return configSource.getMavenReaderFilter().filter(filterRequest);
        }
        catch (MavenFilteringException e) {
            throw new AssemblyFormattingException("Error filtering file '" + source + "': " + e.getMessage(), e);
        }
    }

    public static InputStreamTransformer getFileSetTransformers(final AssemblerConfigurationSource configSource, final boolean isFiltered, String fileSetLineEnding) throws AssemblyFormattingException {
        final String lineEndingHint = fileSetLineEnding;
        String lineEnding = LineEndingsUtils.getLineEndingCharacters(lineEndingHint);
        if (lineEnding != null || isFiltered) {
            return new InputStreamTransformer(){

                public InputStream transform(PlexusIoResource plexusIoResource, InputStream inputStream) throws IOException {
                    if (isFiltered) {
                        String encoding = configSource.getEncoding();
                        InputStreamReader source = encoding != null ? new InputStreamReader(inputStream, encoding) : new InputStreamReader(inputStream);
                        try {
                            Reader filtered = ReaderFormatter.createReaderFilter(source, plexusIoResource.getName(), configSource.getEncoding(), configSource.getEscapeString(), configSource.getDelimiters(), configSource);
                            ReaderInputStream readerInputStream = encoding != null ? new ReaderInputStream(filtered, encoding) : new ReaderInputStream(filtered);
                            LineEndings lineEnding = LineEndingsUtils.getLineEnding(lineEndingHint);
                            if (!LineEndings.keep.equals((Object)lineEnding)) {
                                return LineEndingsUtils.lineEndingConverter((InputStream)readerInputStream, lineEnding);
                            }
                            return readerInputStream;
                        }
                        catch (AssemblyFormattingException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    return inputStream;
                }
            };
        }
        return null;
    }
}

