/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.ReaderFormatter;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiverAttributeUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoSymlink;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResource;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxySymlinkResource;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=AssemblyArchiverPhase.class, hint="file-items")
public class FileItemAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase,
PhaseOrder {
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileItem> fileList = assembly.getFiles();
        File basedir = configSource.getBasedir();
        for (FileItem fileItem : fileList) {
            PlexusIoFileResource res;
            String outputDirectory1;
            String outputDirectory;
            String destName;
            String sourcePath = fileItem.getSource();
            File source = new File(sourcePath);
            String sourceName = source.getName();
            if (!source.isAbsolute()) {
                source = new File(basedir, sourcePath);
            }
            if ((destName = fileItem.getDestName()) == null) {
                destName = sourceName;
            }
            String target = (outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory1 = fileItem.getOutputDirectory(), configSource.getFinalName(), configSource, AssemblyFormatUtils.moduleProjectInterpolator(configSource.getProject()), AssemblyFormatUtils.artifactProjectInterpolator(null))).endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : (outputDirectory.length() < 1 ? destName : outputDirectory + "/" + destName);
            PlexusIoFileResource restoUse = res = new PlexusIoFileResource(source, ArchiverAttributeUtils.getFileAttributes((File)source));
            try {
                final InputStreamTransformer fileSetTransformers = ReaderFormatter.getFileSetTransformers(configSource, fileItem.isFiltered(), fileItem.getLineEnding());
                if (fileSetTransformers != null) {
                    restoUse = new Deferred((PlexusIoResource)res){

                        protected InputStream getInputStream() throws IOException {
                            return fileSetTransformers.transform((PlexusIoResource)res, res.getContents());
                        }

                        public String getName() {
                            return res.getName();
                        }
                    }.asResource();
                }
                int mode = TypeConversionUtils.modeToInt(fileItem.getFileMode(), this.getLogger());
                archiver.addResource((PlexusIoResource)restoUse, target, mode);
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
            }
        }
    }

    public int order() {
        return 10;
    }

    abstract class Deferred {
        final DeferredFileOutputStream dfos;
        final PlexusIoResource resource;

        public Deferred(PlexusIoResource resource) throws IOException {
            this.resource = resource;
            this.dfos = new DeferredFileOutputStream(1000000, "m-assembly-archiver", null, null);
            InputStream inputStream = this.getInputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.dfos);
            IOUtils.closeQuietly((InputStream)inputStream);
        }

        protected abstract InputStream getInputStream() throws IOException;

        @Nonnull
        public InputStream getContents() throws IOException {
            if (this.dfos.isInMemory()) {
                return new ByteArrayInputStream(this.dfos.getData());
            }
            return new FileInputStream(this.dfos.getFile()){

                public void close() throws IOException {
                    super.close();
                    Deferred.this.dfos.getFile().delete();
                }
            };
        }

        public long getSize() {
            if (this.dfos == null) {
                return this.resource.getSize();
            }
            if (this.dfos.isInMemory()) {
                return this.dfos.getByteCount();
            }
            return this.dfos.getFile().length();
        }

        public abstract String getName();

        private PlexusIoResource asSymlinkResource() {
            return new PlexusIoProxySymlinkResource(this.resource){

                public String getName() {
                    return Deferred.this.getName();
                }

                @Nonnull
                public InputStream getContents() throws IOException {
                    return Deferred.this.getContents();
                }

                public long getSize() {
                    return Deferred.this.getSize();
                }
            };
        }

        public PlexusIoResource asResource() {
            if (this.resource instanceof PlexusIoSymlink) {
                return this.asSymlinkResource();
            }
            return new PlexusIoProxyResource(this.resource){

                public String getName() {
                    return Deferred.this.getName();
                }

                @Nonnull
                public InputStream getContents() throws IOException {
                    return Deferred.this.getContents();
                }

                public long getSize() {
                    return Deferred.this.getSize();
                }
            };
        }
    }
}

