/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4 on 2010-10-07 16:51:18,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugin.assembly.model;

/**
 * 
 *         Contains configuration options for including the source
 * files of a
 *         project module in an assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class ModuleSources
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     */
    private boolean useDefaultExcludes = true;

    /**
     * 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    private String outputDirectory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    private String fileMode;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the directory
     * mode of the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *           	
     *           
     */
    private String directoryMode;

    /**
     * Field fileSets.
     */
    private java.util.List<FileSet> fileSets;

    /**
     * 
     *             
     *             Specifies whether the module's finalName should
     * be prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2)
     *             
     *           .
     */
    private boolean includeModuleDirectory = true;

    /**
     * 
     *             
     *             Specifies whether sub-module directories below
     * the current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2)
     *             
     *           .
     */
    private boolean excludeSubModuleDirectories = true;

    /**
     * 
     *             Sets the mapping pattern for all module
     * base-directories included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2)
     *           .
     */
    private String outputDirectoryMapping = "${module.artifactId}";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addFileSet.
     * 
     * @param fileSet
     */
    public void addFileSet( FileSet fileSet )
    {
        getFileSets().add( fileSet );
    } //-- void addFileSet( FileSet )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getFileSets.
     * 
     * @return List
     */
    public java.util.List<FileSet> getFileSets()
    {
        if ( this.fileSets == null )
        {
            this.fileSets = new java.util.ArrayList<FileSet>();
        }

        return this.fileSets;
    } //-- java.util.List<FileSet> getFileSets()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get sets the mapping pattern for all module base-directories
     * included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2).
     * 
     * @return String
     */
    public String getOutputDirectoryMapping()
    {
        return this.outputDirectoryMapping;
    } //-- String getOutputDirectoryMapping()

    /**
     * Get specifies whether sub-module directories below the
     * current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isExcludeSubModuleDirectories()
    {
        return this.excludeSubModuleDirectories;
    } //-- boolean isExcludeSubModuleDirectories()

    /**
     * Get specifies whether the module's finalName should be
     * prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isIncludeModuleDirectory()
    {
        return this.includeModuleDirectory;
    } //-- boolean isIncludeModuleDirectory()

    /**
     * Get whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes()

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeFileSet.
     * 
     * @param fileSet
     */
    public void removeFileSet( FileSet fileSet )
    {
        getFileSets().remove( fileSet );
    } //-- void removeFileSet( FileSet )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param directoryMode
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set specifies whether sub-module directories below the
     * current module should be excluded
     *             from fileSets applied to that module. This might
     * be useful if you only mean to copy
     *             the sources for the exact module list matched by
     * this ModuleSet, ignoring (or processing
     *             separately) the modules which exist in
     * directories below the current one. 
     *             Default value is true. (Since 2.2).
     * 
     * @param excludeSubModuleDirectories
     */
    public void setExcludeSubModuleDirectories( boolean excludeSubModuleDirectories )
    {
        this.excludeSubModuleDirectories = excludeSubModuleDirectories;
    } //-- void setExcludeSubModuleDirectories( boolean )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param fileMode
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set specifies which groups of files from each included
     * module to include in the assembly. A
     *             fileSet is specified by providing one or more of
     * &lt;fileSet&gt; subelements. (Since 2.2).
     * 
     * @param fileSets
     */
    public void setFileSets( java.util.List<FileSet> fileSets )
    {
        this.fileSets = fileSets;
    } //-- void setFileSets( java.util.List )

    /**
     * Set specifies whether the module's finalName should be
     * prepended to the outputDirectory 
     *             values of any fileSets applied to it. Default
     * value is true. (Since 2.2).
     * 
     * @param includeModuleDirectory
     */
    public void setIncludeModuleDirectory( boolean includeModuleDirectory )
    {
        this.includeModuleDirectory = includeModuleDirectory;
    } //-- void setIncludeModuleDirectory( boolean )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     * 
     * @param includes
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set sets the mapping pattern for all module base-directories
     * included in this assembly.
     *             NOTE: This field is only used if
     * includeModuleDirectory == true.
     *             Default is the module's ${artifactId} in
     * 2.2-beta-1, and ${module.artifactId} in subsequent versions.
     * (Since 2.2).
     * 
     * @param outputDirectoryMapping
     */
    public void setOutputDirectoryMapping( String outputDirectoryMapping )
    {
        this.outputDirectoryMapping = outputDirectoryMapping;
    } //-- void setOutputDirectoryMapping( String )

    /**
     * Set whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @param useDefaultExcludes
     */
    public void setUseDefaultExcludes( boolean useDefaultExcludes )
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes( boolean )

}
