/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.mojos;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.archive.ArchiveExpansionException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class UnpackMojo
extends AbstractMojo {
    private MavenProject project;
    private ArchiverManager archiverManager;
    protected File workDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set projectArtifacts;
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            dependencies.add(this.project.getArtifact());
        }
        if ((projectArtifacts = this.project.getArtifacts()) != null) {
            dependencies.addAll(projectArtifacts);
        }
        for (Artifact artifact : dependencies) {
            String name = artifact.getFile().getName();
            File tempLocation = new File(this.workDirectory, name.substring(0, name.lastIndexOf(46)));
            boolean process = false;
            if (!tempLocation.exists()) {
                tempLocation.mkdirs();
                process = true;
            } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
                process = true;
            }
            if (!process) continue;
            File file = artifact.getFile();
            try {
                AssemblyFileUtils.unpack(file, tempLocation, this.archiverManager);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
            catch (ArchiveExpansionException e) {
                throw new MojoExecutionException("Error unpacking dependency file: " + file, (Exception)e);
            }
        }
    }
}

