/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolator;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.io.PrefixedClasspathLocatorStrategy;
import org.apache.maven.plugin.assembly.io.RelativeFileLocatorStrategy;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.Component;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileItem;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.Repository;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Reader;
import org.apache.maven.plugin.assembly.model.io.xpp3.AssemblyXpp3Writer;
import org.apache.maven.plugin.assembly.model.io.xpp3.ComponentXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.io.location.ArtifactLocatorStrategy;
import org.apache.maven.shared.io.location.ClasspathResourceLocatorStrategy;
import org.apache.maven.shared.io.location.FileLocatorStrategy;
import org.apache.maven.shared.io.location.Location;
import org.apache.maven.shared.io.location.Locator;
import org.apache.maven.shared.io.location.LocatorStrategy;
import org.apache.maven.shared.io.location.URLLocatorStrategy;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultAssemblyReader
extends AbstractLogEnabled
implements AssemblyReader {
    private ArtifactFactory factory;
    private ArtifactResolver resolver;

    public List readAssemblies(AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        int i;
        Locator locator = new Locator();
        PrefixedClasspathLocatorStrategy prefixedClasspathStrategy = new PrefixedClasspathLocatorStrategy("/assemblies/");
        ClasspathResourceLocatorStrategy classpathStrategy = new ClasspathResourceLocatorStrategy();
        ArrayList<Object> strategies = new ArrayList<Object>();
        strategies.add(new RelativeFileLocatorStrategy(configSource.getBasedir()));
        strategies.add(new ArtifactLocatorStrategy(this.factory, this.resolver, configSource.getLocalRepository(), configSource.getRemoteRepositories(), "xml", "assembly-descriptor"));
        strategies.add((Object)prefixedClasspathStrategy);
        strategies.add(classpathStrategy);
        strategies.add(new FileLocatorStrategy());
        strategies.add(new URLLocatorStrategy());
        ArrayList<ClasspathResourceLocatorStrategy> refStrategies = new ArrayList<ClasspathResourceLocatorStrategy>();
        refStrategies.add(prefixedClasspathStrategy);
        refStrategies.add(classpathStrategy);
        ArrayList assemblies = new ArrayList();
        String descriptor = configSource.getDescriptor();
        String descriptorId = configSource.getDescriptorId();
        String[] descriptors = configSource.getDescriptors();
        String[] descriptorRefs = configSource.getDescriptorReferences();
        File descriptorSourceDirectory = configSource.getDescriptorSourceDirectory();
        if (descriptor != null) {
            locator.setStrategies(strategies);
            this.addAssemblyFromDescriptor(descriptor, locator, configSource, assemblies);
        }
        if (descriptorId != null) {
            locator.setStrategies(refStrategies);
            this.addAssemblyForDescriptorReference(descriptorId, configSource, assemblies);
        }
        if (descriptors != null && descriptors.length > 0) {
            locator.setStrategies(strategies);
            for (i = 0; i < descriptors.length; ++i) {
                this.getLogger().info("Reading assembly descriptor: " + descriptors[i]);
                this.addAssemblyFromDescriptor(descriptors[i], locator, configSource, assemblies);
            }
        }
        if (descriptorRefs != null && descriptorRefs.length > 0) {
            locator.setStrategies(refStrategies);
            for (i = 0; i < descriptorRefs.length; ++i) {
                this.addAssemblyForDescriptorReference(descriptorRefs[i], configSource, assemblies);
            }
        }
        if (descriptorSourceDirectory != null && descriptorSourceDirectory.isDirectory()) {
            locator.setStrategies(Collections.singletonList(new RelativeFileLocatorStrategy(descriptorSourceDirectory)));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(descriptorSourceDirectory);
            scanner.setIncludes(new String[]{"**/*.xml"});
            scanner.addDefaultExcludes();
            try {
                scanner.scan();
            }
            catch (NullPointerException e) {
                StackTraceElement frameZero = e.getStackTrace()[0];
                if ("org.codehaus.plexus.util.DirectoryScanner".equals(frameZero.getClassName()) && "scandir".equals(frameZero.getMethodName())) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Caught filesystem error while scanning directories...using zero-length list as the result.", (Throwable)e);
                    }
                }
                throw e;
            }
            String[] paths = scanner.getIncludedFiles();
            if (paths != null) {
                for (int i2 = 0; i2 < paths.length; ++i2) {
                    this.addAssemblyFromDescriptor(paths[i2], locator, configSource, assemblies);
                }
            }
        }
        if (assemblies.isEmpty()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptors per configuration. See messages above for specifics.");
            } else {
                throw new AssemblyReadException("No assembly descriptors found.");
            }
        }
        HashSet<String> ids = new HashSet<String>();
        for (Assembly assembly : assemblies) {
            if (ids.add(assembly.getId())) continue;
            this.getLogger().warn("The assembly id " + assembly.getId() + " is used more than once.");
        }
        return assemblies;
    }

    public Assembly getAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyForDescriptorReference(ref, configSource, new ArrayList(1));
    }

    public Assembly getAssemblyFromDescriptorFile(File file, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        return this.addAssemblyFromDescriptorFile(file, configSource, new ArrayList(1));
    }

    private Assembly addAssemblyForDescriptorReference(String ref, AssemblerConfigurationSource configSource, List assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assemblies/" + ref + ".xml");
        if (resourceAsStream == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + ref + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor with ID '" + ref + "' not found");
        }
        try {
            Assembly assembly = this.readAssembly(new InputStreamReader(resourceAsStream, "UTF-8"), ref, configSource);
            assemblies.add(assembly);
            return assembly;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssemblyReadException("Encoding not supported for descriptor with ID '" + ref + "'");
        }
    }

    private Assembly addAssemblyFromDescriptorFile(File descriptor, AssemblerConfigurationSource configSource, List assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        if (!descriptor.exists()) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor: '" + descriptor + "' per configuration.");
                return null;
            }
            throw new AssemblyReadException("Descriptor: '" + descriptor + "' not found");
        }
        InputStreamReader r = null;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(descriptor), "UTF-8");
            Assembly assembly2 = this.readAssembly(r, descriptor.getAbsolutePath(), configSource);
            assemblies.add(assembly2);
            assembly = assembly2;
        }
        catch (IOException e) {
            try {
                throw new AssemblyReadException("Error reading assembly descriptor: " + descriptor, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return assembly;
    }

    private Assembly addAssemblyFromDescriptor(String spec, Locator locator, AssemblerConfigurationSource configSource, List assemblies) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        Location location = locator.resolve(spec);
        if (location == null) {
            if (configSource.isIgnoreMissingDescriptor()) {
                this.getLogger().debug("Ignoring missing assembly descriptor with ID '" + spec + "' per configuration.\nLocator output was:\n\n" + locator.getMessageHolder().render());
                return null;
            }
            throw new AssemblyReadException("Error locating assembly descriptor: " + spec + "\n\n" + locator.getMessageHolder().render());
        }
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(location.getInputStream(), "UTF-8");
            Assembly assembly2 = this.readAssembly(r, spec, configSource);
            assemblies.add(assembly2);
            assembly = assembly2;
        }
        catch (IOException e) {
            try {
                throw new AssemblyReadException("Error reading assembly descriptor: " + spec, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(r);
                throw throwable;
            }
        }
        IOUtil.close((Reader)r);
        return assembly;
    }

    public Assembly readAssembly(Reader reader, String locationDescription, AssemblerConfigurationSource configSource) throws AssemblyReadException, InvalidAssemblerConfigurationException {
        Assembly assembly;
        File basedir = configSource.getBasedir();
        MavenProject project = configSource.getProject();
        try {
            HashMap<Object, Object> context = new HashMap<Object, Object>(System.getProperties());
            context.put("basedir", basedir.getAbsolutePath());
            AssemblyXpp3Reader r = new AssemblyXpp3Reader();
            assembly = r.read(reader);
            this.mergeComponentsWithMainAssembly(assembly, configSource);
            this.debugPrintAssembly("Before assembly is interpolated:", assembly);
            assembly = new AssemblyInterpolator().interpolate(assembly, project, configSource);
            this.debugPrintAssembly("After assembly is interpolated:", assembly);
        }
        catch (IOException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        catch (AssemblyInterpolationException e) {
            throw new AssemblyReadException("Error reading descriptor at: " + locationDescription + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (configSource.isSiteIncluded() || assembly.isIncludeSiteDirectory()) {
            this.includeSiteInAssembly(assembly, configSource);
        }
        return assembly;
    }

    private void debugPrintAssembly(String message, Assembly assembly) {
        StringWriter sWriter = new StringWriter();
        try {
            new AssemblyXpp3Writer().write(sWriter, assembly);
        }
        catch (IOException e) {
            this.getLogger().debug("Failed to print debug message with assembly descriptor listing, and message: " + message, (Throwable)e);
        }
        this.getLogger().debug(message + "\n\n" + sWriter.toString() + "\n\n");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeComponentsWithMainAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws AssemblyReadException {
        RelativeFileLocatorStrategy rfls = new RelativeFileLocatorStrategy(configSource.getBasedir());
        FileLocatorStrategy afls = new FileLocatorStrategy();
        ClasspathResourceLocatorStrategy crls = new ClasspathResourceLocatorStrategy();
        ArtifactLocatorStrategy als = new ArtifactLocatorStrategy(this.factory, this.resolver, configSource.getLocalRepository(), configSource.getRemoteRepositories(), "assembly-component");
        URLLocatorStrategy uls = new URLLocatorStrategy();
        Locator locator = new Locator();
        locator.addStrategy((LocatorStrategy)rfls);
        locator.addStrategy((LocatorStrategy)afls);
        locator.addStrategy((LocatorStrategy)als);
        locator.addStrategy((LocatorStrategy)crls);
        locator.addStrategy((LocatorStrategy)uls);
        AssemblyExpressionEvaluator aee = new AssemblyExpressionEvaluator(configSource);
        List componentLocations = assembly.getComponentDescriptors();
        Iterator it = componentLocations.iterator();
        while (it.hasNext()) {
            String location = (String)it.next();
            try {
                location = aee.evaluate(location).toString();
            }
            catch (Exception eee) {
                this.getLogger().error("Error interpolating componentDescriptor: " + location, (Throwable)eee);
            }
            Location resolvedLocation = locator.resolve(location);
            if (resolvedLocation == null) {
                throw new AssemblyReadException("Failed to locate component descriptor: " + location);
            }
            Component component = null;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(resolvedLocation.getInputStream());
                component = new ComponentXpp3Reader().read(reader);
            }
            catch (IOException e) {
                try {
                    throw new AssemblyReadException("Error reading component descriptor", e);
                    catch (XmlPullParserException e2) {
                        throw new AssemblyReadException("Error reading component descriptor", e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
            this.mergeComponentWithAssembly(component, assembly);
        }
        return;
    }

    protected void mergeComponentWithAssembly(Component component, Assembly assembly) {
        List containerHandlerDescriptors = component.getContainerDescriptorHandlers();
        for (ContainerDescriptorHandlerConfig cfg : containerHandlerDescriptors) {
            assembly.addContainerDescriptorHandler(cfg);
        }
        List dependencySetList = component.getDependencySets();
        for (DependencySet dependencySet : dependencySetList) {
            assembly.addDependencySet(dependencySet);
        }
        List fileSetList = component.getFileSets();
        for (FileSet fileSet : fileSetList) {
            assembly.addFileSet(fileSet);
        }
        List fileList = component.getFiles();
        for (FileItem fileItem : fileList) {
            assembly.addFile(fileItem);
        }
        List repositoriesList = component.getRepositories();
        for (Repository repository : repositoriesList) {
            assembly.addRepository(repository);
        }
    }

    public void includeSiteInAssembly(Assembly assembly, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        File siteDirectory = configSource.getSiteDirectory();
        if (!siteDirectory.exists()) {
            throw new InvalidAssemblerConfigurationException("site did not exist in the target directory - please run site:site before creating the assembly");
        }
        this.getLogger().info("Adding site directory to assembly : " + siteDirectory);
        FileSet siteFileSet = new FileSet();
        siteFileSet.setDirectory(siteDirectory.getPath());
        siteFileSet.setOutputDirectory("/site");
        assembly.addFileSet(siteFileSet);
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "assemblyReader-internal");
            this.enableLogging(logger);
        }
        return logger;
    }
}

