/*
 * $Id$
 */

package org.apache.maven.plugin.assembly.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *       Specifies options for including/excluding/filtering items
 * extracted from an archive.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class UnpackOptions
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includes.
     */
    private java.util.List/*<String>*/ includes;

    /**
     * Field excludes.
     */
    private java.util.List/*<String>*/ excludes;

    /**
     * 
     *           Whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration.
     *           
     */
    private boolean filtered = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "UnpackOptions.addExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "UnpackOptions.addIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List/*<String>*/ getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList/*<String>*/();
        }

        return this.excludes;
    } //-- java.util.List/*<String>*/ getExcludes()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List/*<String>*/ getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList/*<String>*/();
        }

        return this.includes;
    } //-- java.util.List/*<String>*/ getIncludes()

    /**
     * Get 
     *           Whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration.
     *           
     * 
     * @return boolean
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered()

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "UnpackOptions.removeExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "UnpackOptions.removeIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set 
     *           Set of patterns for matching items to be excluded
     * from an archive as it is unpacked.
     *           
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List/*<String>*/ excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set 
     *           Whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration.
     *           
     * 
     * @param filtered
     */
    public void setFiltered( boolean filtered )
    {
        this.filtered = filtered;
    } //-- void setFiltered( boolean )

    /**
     * Set 
     *           Set of patterns for matching items to be included
     * from an archive as it is unpacked.
     *           
     * 
     * @param includes
     */
    public void setIncludes( java.util.List/*<String>*/ includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )


}
