/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.task.ArchiverTask;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.FileUtils;

public class AddDirectoryTask
implements ArchiverTask {
    private final File directory;
    private List includes;
    private List excludes;
    private String outputDirectory;
    private boolean useDefaultExcludes = true;
    private int directoryMode = -1;
    private int fileMode = -1;

    public AddDirectoryTask(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException {
        block12: {
            if (".".equals(this.outputDirectory)) {
                this.outputDirectory = "";
            } else if ("..".equals(this.outputDirectory)) {
                throw new ArchiveCreationException("Cannot add source directory: " + this.directory + " to archive-path: " + this.outputDirectory + ". All paths must be within the archive root directory.");
            }
            int oldDirMode = archiver.getDefaultDirectoryMode();
            int oldFileMode = archiver.getDefaultFileMode();
            try {
                if (this.directoryMode > -1) {
                    archiver.setDefaultDirectoryMode(this.directoryMode);
                }
                if (this.fileMode > -1) {
                    archiver.setDefaultFileMode(this.fileMode);
                }
                if (!this.directory.exists()) break block12;
                ArrayList directoryExcludes = this.excludes != null && !this.excludes.isEmpty() ? new ArrayList(this.excludes) : new ArrayList();
                if (this.useDefaultExcludes) {
                    directoryExcludes.addAll(FileUtils.getDefaultExcludesAsList());
                }
                try {
                    String[] includesArray = null;
                    if (this.includes != null && !this.includes.isEmpty()) {
                        includesArray = this.includes.toArray(new String[0]);
                    }
                    String[] excludesArray = directoryExcludes.toArray(new String[0]);
                    archiver.addDirectory(this.directory, this.outputDirectory, includesArray, excludesArray);
                }
                catch (ArchiverException e) {
                    throw new ArchiveCreationException("Error adding directory to archive: " + e.getMessage(), e);
                }
            }
            finally {
                archiver.setDefaultDirectoryMode(oldDirMode);
                archiver.setDefaultFileMode(oldFileMode);
            }
        }
    }

    public void setExcludes(List excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List includes) {
        this.includes = includes;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

