/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.BuildInfoWriter;
import org.apache.maven.plugins.artifact.buildinfo.PluginUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractBuildinfoMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}.buildinfo", required=true, readonly=true)
    protected File buildinfoFile;
    @Parameter(property="buildinfo.ignoreJavadoc", defaultValue="true")
    private boolean ignoreJavadoc;
    @Parameter(property="buildinfo.ignore", defaultValue="")
    private List<String> ignore;
    @Parameter(property="buildinfo.detect.skip", defaultValue="true")
    private boolean detectSkip;
    @Parameter
    private List<String> skipModules;
    private List<PathMatcher> skipModulesMatcher = null;
    @Parameter(property="buildinfo.reproducible", defaultValue="false")
    private boolean reproducible;
    @Component
    private MavenSession session;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Component
    protected RuntimeInformation rtInformation;

    public void execute() throws MojoExecutionException {
        boolean mono = this.reactorProjects.size() == 1;
        MavenArchiver archiver = new MavenArchiver();
        Date timestamp = archiver.parseOutputTimestamp(this.outputTimestamp);
        if (timestamp == null) {
            this.getLog().warn((CharSequence)"Reproducible Build not activated by project.build.outputTimestamp property: see https://maven.apache.org/guides/mini/guide-reproducible-builds.html");
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("project.build.outputTimestamp = \"" + this.outputTimestamp + "\" => " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").format(timestamp)));
            }
            boolean parentInReactor = false;
            MavenProject reactorParent = this.project;
            while (this.reactorProjects.contains(reactorParent.getParent())) {
                parentInReactor = true;
                reactorParent = reactorParent.getParent();
            }
            String prop = reactorParent.getOriginalModel().getProperties().getProperty("project.build.outputTimestamp");
            if (prop == null) {
                this.getLog().error((CharSequence)("project.build.outputTimestamp property should not be inherited but defined in " + (parentInReactor ? "parent POM from reactor " : "POM ") + reactorParent.getFile()));
            }
        }
        if (!mono) {
            if (this.isSkip(this.project)) {
                this.getLog().info((CharSequence)"Skipping goal because module skips install and/or deploy");
                return;
            }
            MavenProject last = this.getLastProject();
            if (this.project != last) {
                this.skip(last);
                return;
            }
        }
        Map<Artifact, String> artifacts = this.generateBuildinfo(mono);
        this.getLog().info((CharSequence)("Saved " + (mono ? "" : "aggregate ") + "info on build to " + this.buildinfoFile));
        this.copyAggregateToRoot(this.buildinfoFile);
        this.execute(artifacts);
    }

    abstract void execute(Map<Artifact, String> var1) throws MojoExecutionException;

    protected void skip(MavenProject last) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Skipping intermediate goal run, aggregate will be " + last.getArtifactId()));
    }

    protected void copyAggregateToRoot(File aggregate) throws MojoExecutionException {
        if (this.reactorProjects.size() == 1) {
            return;
        }
        MavenProject root = this.getExecutionRoot();
        String extension = aggregate.getName().substring(aggregate.getName().lastIndexOf(46));
        File rootCopy = new File(root.getBuild().getDirectory(), root.getArtifactId() + '-' + root.getVersion() + extension);
        try {
            FileUtils.copyFile((File)aggregate, (File)rootCopy);
            this.getLog().info((CharSequence)("Aggregate " + extension.substring(1) + " copied to " + rootCopy));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not copy " + aggregate + "to " + rootCopy);
        }
    }

    protected Map<Artifact, String> generateBuildinfo(boolean mono) throws MojoExecutionException {
        MavenProject root = mono ? this.project : this.getExecutionRoot();
        this.buildinfoFile.getParentFile().mkdirs();
        PrintWriter p = new PrintWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.buildinfoFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8)));
        try {
            BuildInfoWriter bi = new BuildInfoWriter(this.getLog(), p, mono, this.artifactHandlerManager, this.rtInformation);
            bi.setIgnoreJavadoc(this.ignoreJavadoc);
            bi.setIgnore(this.ignore);
            bi.setToolchain(this.getToolchain());
            bi.printHeader(root, mono ? null : this.project, this.reproducible);
            if (mono) {
                bi.printArtifacts(this.project);
            } else {
                for (MavenProject project : this.reactorProjects) {
                    if (this.isSkip(project)) continue;
                    bi.printArtifacts(project);
                }
            }
            if (p.checkError()) {
                throw new MojoExecutionException("Write error to " + this.buildinfoFile);
            }
            Map<Artifact, String> map = bi.getArtifacts();
            p.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating file " + this.buildinfoFile, (Exception)e);
            }
        }
    }

    protected MavenProject getExecutionRoot() {
        for (MavenProject p : this.reactorProjects) {
            if (!p.isExecutionRoot()) continue;
            return p;
        }
        return null;
    }

    private MavenProject getLastProject() {
        int i = this.reactorProjects.size();
        while (i > 0) {
            MavenProject project;
            if (this.isSkip(project = this.reactorProjects.get(--i))) continue;
            return project;
        }
        return null;
    }

    private boolean isSkip(MavenProject project) {
        boolean skipModule = false;
        if (this.skipModules != null && !this.skipModules.isEmpty()) {
            if (this.skipModulesMatcher == null) {
                FileSystem fs = FileSystems.getDefault();
                this.skipModulesMatcher = this.skipModules.stream().map(i -> fs.getPathMatcher("glob:" + i)).collect(Collectors.toList());
            }
            Path path = Paths.get(project.getGroupId() + '/' + project.getArtifactId(), new String[0]);
            skipModule = this.skipModulesMatcher.stream().anyMatch(m -> m.matches(path));
        }
        return skipModule || this.detectSkip && PluginUtil.isSkip(project);
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

