/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.Toolchain;

class JdkToolchainUtil {
    JdkToolchainUtil() {
    }

    static String getJavaVersion(Toolchain toolchain) {
        String version = "unknown";
        String java = toolchain.findTool("java");
        if (java != null) {
            try {
                Commandline cl = new Commandline(java + " -version");
                LineConsumer out = new LineConsumer();
                LineConsumer err = new LineConsumer();
                CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)err);
                version = StringUtils.join(err.getLines().iterator(), (String)":");
                if (version == null) {
                    version = "unable to detect...";
                }
            }
            catch (CommandLineException cle) {
                version = cle.toString();
            }
        }
        return version;
    }

    private static class LineConsumer
    implements StreamConsumer {
        private List<String> lines = new ArrayList<String>();

        private LineConsumer() {
        }

        public void consumeLine(String line) throws IOException {
            this.lines.add(line);
        }

        List<String> getLines() {
            return this.lines;
        }
    }
}

