/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class PluginUtil {
    PluginUtil() {
    }

    static boolean isSkip(MavenProject project) {
        return PluginUtil.isSkip(project, "install") || PluginUtil.isSkip(project, "deploy");
    }

    private static boolean isSkip(MavenProject project, String id) {
        Plugin plugin = PluginUtil.getPlugin(project, "org.apache.maven.plugins:maven-" + id + "-plugin");
        String skip = PluginUtil.getPluginParameter(plugin, "skip");
        if (skip == null) {
            skip = project.getProperties().getProperty("maven." + id + ".skip");
        }
        return Boolean.valueOf(skip);
    }

    private static Plugin getPlugin(MavenProject project, String plugin) {
        Map pluginsAsMap = project.getBuild().getPluginsAsMap();
        Plugin result = (Plugin)pluginsAsMap.get(plugin);
        if (result == null) {
            pluginsAsMap = project.getPluginManagement().getPluginsAsMap();
            result = (Plugin)pluginsAsMap.get(plugin);
        }
        return result;
    }

    private static String getPluginParameter(Plugin plugin, String parameter) {
        Xpp3Dom target;
        Xpp3Dom pluginConf;
        if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
            return target.getValue();
        }
        return null;
    }
}

