/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.artifact.buildinfo.DigestHelper;
import org.apache.maven.plugins.artifact.buildinfo.JdkToolchainUtil;
import org.apache.maven.plugins.artifact.buildinfo.MavenVersion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.PropertyUtils;
import org.apache.maven.toolchain.Toolchain;

class BuildInfoWriter {
    private final Log log;
    private final PrintWriter p;
    private final boolean mono;
    private final Map<Artifact, String> artifacts = new LinkedHashMap<Artifact, String>();
    private int projectCount = -1;
    private boolean ignoreJavadoc = true;
    private Set<String> ignore;
    private Toolchain toolchain;

    BuildInfoWriter(Log log, PrintWriter p, boolean mono) {
        this.log = log;
        this.p = p;
        this.mono = mono;
    }

    void printHeader(MavenProject project, MavenProject aggregate) {
        this.p.println("# https://reproducible-builds.org/docs/jvm/");
        this.p.println("buildinfo.version=1.0-SNAPSHOT");
        this.p.println();
        this.p.println("name=" + project.getName());
        this.p.println("group-id=" + project.getGroupId());
        this.p.println("artifact-id=" + project.getArtifactId());
        this.p.println("version=" + project.getVersion());
        this.p.println();
        this.printSourceInformation(project);
        this.p.println();
        this.p.println("# build instructions");
        this.p.println("build-tool=mvn");
        this.p.println();
        this.p.println("# effective build environment information");
        this.p.println("java.version=" + System.getProperty("java.version"));
        this.p.println("java.vendor=" + System.getProperty("java.vendor"));
        this.p.println("os.name=" + System.getProperty("os.name"));
        this.p.println();
        this.p.println("# Maven rebuild instructions and effective environment");
        this.p.println("mvn.version=" + MavenVersion.createMavenVersionString());
        if (project.getPrerequisites() != null && project.getPrerequisites().getMaven() != null) {
            this.p.println("mvn.minimum.version=" + project.getPrerequisites().getMaven());
        }
        if (this.toolchain != null) {
            this.p.println("mvn.toolchain.jdk=" + JdkToolchainUtil.getJavaVersion(this.toolchain));
        }
        if (!this.mono && aggregate != null) {
            this.p.println("mvn.aggregate.artifact-id=" + aggregate.getArtifactId());
        }
        this.p.println();
        this.p.println("# " + (this.mono ? "" : "aggregated ") + "output");
    }

    private void printSourceInformation(MavenProject project) {
        boolean sourceAvailable = false;
        this.p.println("# source information");
        if (project.getScm() != null) {
            sourceAvailable = true;
            this.p.println("source.scm.uri=" + project.getScm().getConnection());
            this.p.println("source.scm.tag=" + project.getScm().getTag());
            if (project.getArtifact().isSnapshot()) {
                this.log.warn((CharSequence)("SCM source tag in buildinfo source.scm.tag=" + project.getScm().getTag() + " does not permit rebuilders reproducible source checkout"));
            }
        } else {
            this.p.println("# no scm configured in pom.xml");
        }
        if (!sourceAvailable) {
            this.log.warn((CharSequence)"No source information available in buildinfo for rebuilders...");
        }
    }

    void printArtifacts(MavenProject project) throws MojoExecutionException {
        if (project.getArtifact() == null) {
            return;
        }
        String prefix = "outputs.";
        if (!this.mono) {
            ++this.projectCount;
            prefix = prefix + this.projectCount + ".";
            this.p.println();
            this.p.println(prefix + "coordinates=" + project.getGroupId() + ':' + project.getArtifactId());
        }
        int n = 0;
        if (project.getArtifact().getFile() != null) {
            this.printArtifact(prefix, n++, project.getArtifact());
        }
        for (Artifact attached : project.getAttachedArtifacts()) {
            if (attached.getType().endsWith(".asc") || this.ignoreJavadoc && "javadoc".equals(attached.getClassifier()) || this.isIgnore(attached)) continue;
            this.printArtifact(prefix, n++, attached);
        }
    }

    private void printArtifact(String prefix, int i, Artifact artifact) throws MojoExecutionException {
        prefix = prefix + i;
        if (artifact.getFile().isDirectory()) {
            throw new MojoExecutionException("Artifact " + artifact.getId() + " points to a directory: " + artifact.getFile() + ". Packaging should be 'pom'?");
        }
        this.printFile(prefix, artifact.getFile(), this.getArtifactFilename(artifact));
        this.artifacts.put(artifact, prefix);
    }

    private String getArtifactFilename(Artifact artifact) {
        ArtifactHandler artifactHandler;
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getBaseVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if ((artifactHandler = artifact.getArtifactHandler()).getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    void printFile(String prefix, File file) throws MojoExecutionException {
        this.printFile(prefix, file, file.getName());
    }

    private void printFile(String prefix, File file, String filename) throws MojoExecutionException {
        this.p.println();
        this.p.println(prefix + ".filename=" + filename);
        this.p.println(prefix + ".length=" + file.length());
        this.p.println(prefix + ".checksums.sha512=" + DigestHelper.calculateSha512(file));
    }

    Map<Artifact, String> getArtifacts() {
        return this.artifacts;
    }

    static Properties loadOutputProperties(File buildinfo) throws MojoExecutionException {
        Properties prop = PropertyUtils.loadOptionalProperties((File)buildinfo);
        for (String name : prop.stringPropertyNames()) {
            if (name.startsWith("outputs.") && !name.endsWith(".coordinates")) continue;
            prop.remove(name);
        }
        return prop;
    }

    boolean getIgnoreJavadoc() {
        return this.ignoreJavadoc;
    }

    void setIgnoreJavadoc(boolean ignoreJavadoc) {
        this.ignoreJavadoc = ignoreJavadoc;
    }

    void setIgnore(Set<String> ignore) {
        this.ignore = ignore;
    }

    private boolean isIgnore(Artifact attached) {
        String classifier = attached.getClassifier();
        String extension = attached.getType();
        String search = classifier == null ? "" : classifier + '.' + extension;
        return this.ignore.contains(search);
    }

    public void setToolchain(Toolchain toolchain) {
        this.toolchain = toolchain;
    }
}

