/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antlr;

import antlr.Tool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antlr.NoExitSecurityManager;
import org.apache.maven.project.MavenProject;

public class AntlrPlugin
extends AbstractMojo {
    private String grammars;
    private String sourceDirectory;
    private String outputDirectory;
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        StringTokenizer st = new StringTokenizer(this.grammars, ", ");
        while (st.hasMoreTokens()) {
            String eachGrammar = st.nextToken().trim();
            File grammar = new File(this.sourceDirectory, eachGrammar);
            this.getLog().info((CharSequence)("grammar: " + grammar));
            File generated = null;
            try {
                generated = this.getGeneratedFile(grammar.getPath(), this.outputDirectory);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to get generated file", e);
            }
            if (generated.exists() && generated.lastModified() > grammar.lastModified()) {
                this.getLog().info((CharSequence)"The grammar is already generated");
                continue;
            }
            if (!generated.getParentFile().exists()) {
                generated.getParentFile().mkdirs();
            }
            String[] args = new String[]{"-o", generated.getParentFile().getPath(), grammar.getPath()};
            SecurityManager oldSm = System.getSecurityManager();
            System.setSecurityManager(NoExitSecurityManager.INSTANCE);
            try {
                Tool.main((String[])args);
            }
            catch (SecurityException e) {
                if (e.getMessage().equals("exitVM-0")) continue;
                throw new MojoExecutionException("Execution failed", (Exception)e);
            }
            finally {
                System.setSecurityManager(oldSm);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.outputDirectory);
        }
    }

    protected File getGeneratedFile(String grammar, String outputDirectory) throws Exception {
        String generatedFileName = null;
        String packageName = "";
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(grammar));
            while ((line = in.readLine()) != null) {
                line = line.trim();
                int extendsIndex = line.indexOf(" extends ");
                if (line.startsWith("class ") && extendsIndex > -1) {
                    generatedFileName = line.substring(6, extendsIndex).trim();
                    break;
                }
                if (!line.startsWith("package")) continue;
                packageName = line.substring(8).trim();
            }
            in.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to determine generated class", e);
        }
        if (generatedFileName == null) {
            return null;
        }
        File genFile = null;
        if ("".equals(packageName)) {
            genFile = new File(outputDirectory, generatedFileName + ".java");
        } else {
            String packagePath = packageName.replace('.', File.separatorChar);
            packagePath = packagePath.replace(';', File.separatorChar);
            genFile = new File(new File(outputDirectory, packagePath), generatedFileName + ".java");
        }
        return genFile;
    }
}

