/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.acr;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="acr", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class AcrMojo
extends AbstractMojo {
    private static final String APP_CLIENT_XML = "META-INF/application-client.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{"META-INF/application-client.xml"};
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File basedir;
    @Parameter(property="maven.acr.outputDirectory", defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    private String jarName;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="maven.acr.escapeBackslashesInFilePath", defaultValue="false")
    private boolean escapeBackslashesInFilePath;
    @Parameter(property="maven.acr.escapeString")
    private String escapeString;
    @Parameter(property="maven.acr.filterDeploymentDescriptor", defaultValue="false")
    private boolean filterDeploymentDescriptor;
    @Parameter
    private List<String> filters;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Building JavaEE Application client: " + this.jarName));
        }
        File jarFile = AcrMojo.getAppClientJarFile(this.basedir, this.jarName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        try {
            String[] mainJarExcludes = DEFAULT_EXCLUDES;
            if (this.excludes != null && !this.excludes.isEmpty()) {
                this.excludes.add(APP_CLIENT_XML);
                mainJarExcludes = this.excludes.toArray(new String[this.excludes.size()]);
            }
            if (this.outputDirectory.exists()) {
                archiver.getArchiver().addDirectory(this.outputDirectory, DEFAULT_INCLUDES, mainJarExcludes);
            } else {
                this.getLog().info((CharSequence)"JAR will only contain the META-INF/application-client.xml as no content was marked for inclusion");
            }
            File deploymentDescriptor = new File(this.outputDirectory, APP_CLIENT_XML);
            if (deploymentDescriptor.exists()) {
                if (this.filterDeploymentDescriptor) {
                    this.getLog().debug((CharSequence)"Filtering deployment descriptor.");
                    MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                    mavenResourcesExecution.setEscapeString(this.escapeString);
                    List filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapeBackslashesInFilePath, this.session, mavenResourcesExecution);
                    File unfilteredDeploymentDescriptor = new File(this.outputDirectory, "META-INF/application-client.xml.unfiltered");
                    FileUtils.copyFile((File)deploymentDescriptor, (File)unfilteredDeploymentDescriptor);
                    this.mavenFileFilter.copyFile(unfilteredDeploymentDescriptor, deploymentDescriptor, true, filterWrappers, this.getEncoding(unfilteredDeploymentDescriptor));
                    FileUtils.forceDelete((File)unfilteredDeploymentDescriptor);
                }
                archiver.getArchiver().addFile(deploymentDescriptor, APP_CLIENT_XML);
            }
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the JavaEE Application Client  archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem reading / creating the manifest for the JavaEE Application Client  archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a I/O problem creating the JavaEE Application Client archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem resolving dependencies while creating the JavaEE Application Client archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("There was a problem filtering the deployment descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        this.project.getArtifact().setFile(jarFile);
    }

    private static File getAppClientJarFile(File basedir, String finalName) {
        return new File(basedir, finalName + ".jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncoding(File xmlFile) throws IOException {
        String string;
        XmlStreamReader xmlReader = null;
        try {
            xmlReader = new XmlStreamReader(xmlFile);
            String encoding = xmlReader.getEncoding();
            xmlReader.close();
            xmlReader = null;
            string = encoding;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xmlReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)xmlReader);
        return string;
    }
}

