/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.tools.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.tools.model.Component;
import org.apache.maven.plugin.tools.model.LifecycleExecution;
import org.apache.maven.plugin.tools.model.Mojo;
import org.apache.maven.plugin.tools.model.Parameter;
import org.apache.maven.plugin.tools.model.PluginMetadata;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginMetadataXpp3Reader {
    private boolean addDefaultEntities = true;

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public PluginMetadata read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public PluginMetadata read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public PluginMetadata read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public PluginMetadata read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private Component parseComponent(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Component component = new Component();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "role", null, parsed)) {
                component.setRole(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "hint", null, parsed)) {
                component.setHint(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return component;
    }

    private LifecycleExecution parseLifecycleExecution(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LifecycleExecution lifecycleExecution = new LifecycleExecution();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "lifecycle", null, parsed)) {
                lifecycleExecution.setLifecycle(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phase", null, parsed)) {
                lifecycleExecution.setPhase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goal", null, parsed)) {
                lifecycleExecution.setGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return lifecycleExecution;
    }

    private Mojo parseMojo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Mojo mojo = new Mojo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "goal", null, parsed)) {
                mojo.setGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "phase", null, parsed)) {
                mojo.setPhase(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "aggregator", null, parsed)) {
                mojo.setAggregator(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "aggregator", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresDependencyResolution", null, parsed)) {
                mojo.setRequiresDependencyResolution(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresProject", null, parsed)) {
                mojo.setRequiresProject(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "requiresProject", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresReports", null, parsed)) {
                mojo.setRequiresReports(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "requiresReports", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresOnline", null, parsed)) {
                mojo.setRequiresOnline(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "requiresOnline", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "inheritByDefault", null, parsed)) {
                mojo.setInheritByDefault(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "inheritByDefault", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "requiresDirectInvocation", null, parsed)) {
                mojo.setRequiresDirectInvocation(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "requiresDirectInvocation", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "execution", null, parsed)) {
                mojo.setExecution(this.parseLifecycleExecution(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "components", null, parsed)) {
                ArrayList<Component> components = new ArrayList<Component>();
                mojo.setComponents(components);
                while (parser.nextTag() == 2) {
                    if ("component".equals(parser.getName())) {
                        components.add(this.parseComponent(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "parameters", null, parsed)) {
                ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                mojo.setParameters(parameters);
                while (parser.nextTag() == 2) {
                    if ("parameter".equals(parser.getName())) {
                        parameters.add(this.parseParameter(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                mojo.setDescription(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "deprecated", null, parsed)) {
                mojo.setDeprecation(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "since", null, parsed)) {
                mojo.setSince(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "call", null, parsed)) {
                mojo.setCall(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return mojo;
    }

    private Parameter parseParameter(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Parameter parameter = new Parameter();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                parameter.setName(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "alias", null, parsed)) {
                parameter.setAlias(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "property", null, parsed)) {
                parameter.setProperty(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "required", null, parsed)) {
                parameter.setRequired(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "required", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "readonly", null, parsed)) {
                parameter.setReadonly(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "readonly", parser, "false"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "expression", null, parsed)) {
                parameter.setExpression(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "defaultValue", null, parsed)) {
                parameter.setDefaultValue(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                parameter.setType(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                parameter.setDescription(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "deprecated", null, parsed)) {
                parameter.setDeprecation(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "since", null, parsed)) {
                parameter.setSince(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return parameter;
    }

    private PluginMetadata parsePluginMetadata(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PluginMetadata pluginMetadata = new PluginMetadata();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "mojos", null, parsed)) {
                ArrayList<Mojo> mojos = new ArrayList<Mojo>();
                pluginMetadata.setMojos(mojos);
                while (parser.nextTag() == 2) {
                    if ("mojo".equals(parser.getName())) {
                        mojos.add(this.parseMojo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return pluginMetadata;
    }

    private PluginMetadata read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"pluginMetadata".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'pluginMetadata' but found '" + parser.getName() + "'", parser, null);
                }
                PluginMetadata pluginMetadata = this.parsePluginMetadata(parser, strict);
                pluginMetadata.setModelEncoding(parser.getInputEncoding());
                return pluginMetadata;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'pluginMetadata' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

