// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.plugin.tools.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.plugin.tools.model.Component;
import org.apache.maven.plugin.tools.model.LifecycleExecution;
import org.apache.maven.plugin.tools.model.Mojo;
import org.apache.maven.plugin.tools.model.Parameter;
import org.apache.maven.plugin.tools.model.PluginMetadata;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class PluginMetadataXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class PluginMetadataXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser
     * @param parsed
     * @param alias
     * @param tagName
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser
     * @param strict
     * @param tagName
     * @param attribute
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser
     * @param strict
     * @throws XmlPullParserException
     * @throws IOException
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s
     * @param defaultValue
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s
     * @param parser
     * @param dateFormat
     * @param attribute
     * @throws XmlPullParserException
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s
     * @param strict
     * @param parser
     * @param attribute
     * @throws XmlPullParserException
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method nextTag.
     * 
     * @param parser
     * @throws IOException
     * @throws XmlPullParserException
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    public PluginMetadata read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- PluginMetadata read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    public PluginMetadata read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- PluginMetadata read( Reader )

    /**
     * Method read.
     * 
     * @param in
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    public PluginMetadata read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- PluginMetadata read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    public PluginMetadata read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- PluginMetadata read( InputStream )

    /**
     * Method parseComponent.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Component
     */
    private Component parseComponent( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Component component = new Component();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "role", null, parsed ) )
            {
                component.setRole( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "hint", null, parsed ) )
            {
                component.setHint( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return component;
    } //-- Component parseComponent( XmlPullParser, boolean )

    /**
     * Method parseLifecycleExecution.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return LifecycleExecution
     */
    private LifecycleExecution parseLifecycleExecution( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LifecycleExecution lifecycleExecution = new LifecycleExecution();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "lifecycle", null, parsed ) )
            {
                lifecycleExecution.setLifecycle( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "phase", null, parsed ) )
            {
                lifecycleExecution.setPhase( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "goal", null, parsed ) )
            {
                lifecycleExecution.setGoal( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return lifecycleExecution;
    } //-- LifecycleExecution parseLifecycleExecution( XmlPullParser, boolean )

    /**
     * Method parseMojo.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Mojo
     */
    private Mojo parseMojo( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Mojo mojo = new Mojo();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "goal", null, parsed ) )
            {
                mojo.setGoal( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "phase", null, parsed ) )
            {
                mojo.setPhase( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "aggregator", null, parsed ) )
            {
                mojo.setAggregator( getBooleanValue( getTrimmedValue( parser.nextText() ), "aggregator", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "requiresDependencyResolution", null, parsed ) )
            {
                mojo.setRequiresDependencyResolution( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "requiresProject", null, parsed ) )
            {
                mojo.setRequiresProject( getBooleanValue( getTrimmedValue( parser.nextText() ), "requiresProject", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "requiresReports", null, parsed ) )
            {
                mojo.setRequiresReports( getBooleanValue( getTrimmedValue( parser.nextText() ), "requiresReports", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "requiresOnline", null, parsed ) )
            {
                mojo.setRequiresOnline( getBooleanValue( getTrimmedValue( parser.nextText() ), "requiresOnline", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "inheritByDefault", null, parsed ) )
            {
                mojo.setInheritByDefault( getBooleanValue( getTrimmedValue( parser.nextText() ), "inheritByDefault", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "requiresDirectInvocation", null, parsed ) )
            {
                mojo.setRequiresDirectInvocation( getBooleanValue( getTrimmedValue( parser.nextText() ), "requiresDirectInvocation", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "execution", null, parsed ) )
            {
                mojo.setExecution( parseLifecycleExecution( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "components", null, parsed ) )
            {
                java.util.List components = new java.util.ArrayList/*<Component>*/();
                mojo.setComponents( components );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "component".equals( parser.getName() ) )
                    {
                        components.add( parseComponent( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "parameters", null, parsed ) )
            {
                java.util.List parameters = new java.util.ArrayList/*<Parameter>*/();
                mojo.setParameters( parameters );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "parameter".equals( parser.getName() ) )
                    {
                        parameters.add( parseParameter( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "description", null, parsed ) )
            {
                mojo.setDescription( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "deprecated", null, parsed ) )
            {
                mojo.setDeprecation( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "since", null, parsed ) )
            {
                mojo.setSince( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "call", null, parsed ) )
            {
                mojo.setCall( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return mojo;
    } //-- Mojo parseMojo( XmlPullParser, boolean )

    /**
     * Method parseParameter.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return Parameter
     */
    private Parameter parseParameter( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Parameter parameter = new Parameter();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "name", null, parsed ) )
            {
                parameter.setName( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "alias", null, parsed ) )
            {
                parameter.setAlias( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "property", null, parsed ) )
            {
                parameter.setProperty( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "required", null, parsed ) )
            {
                parameter.setRequired( getBooleanValue( getTrimmedValue( parser.nextText() ), "required", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "readonly", null, parsed ) )
            {
                parameter.setReadonly( getBooleanValue( getTrimmedValue( parser.nextText() ), "readonly", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "expression", null, parsed ) )
            {
                parameter.setExpression( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "defaultValue", null, parsed ) )
            {
                parameter.setDefaultValue( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "type", null, parsed ) )
            {
                parameter.setType( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "description", null, parsed ) )
            {
                parameter.setDescription( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "deprecated", null, parsed ) )
            {
                parameter.setDeprecation( getTrimmedValue( parser.nextText() ) );
            }
            else if ( checkFieldWithDuplicate( parser, "since", null, parsed ) )
            {
                parameter.setSince( getTrimmedValue( parser.nextText() ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return parameter;
    } //-- Parameter parseParameter( XmlPullParser, boolean )

    /**
     * Method parsePluginMetadata.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    private PluginMetadata parsePluginMetadata( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PluginMetadata pluginMetadata = new PluginMetadata();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "mojos", null, parsed ) )
            {
                java.util.List mojos = new java.util.ArrayList/*<Mojo>*/();
                pluginMetadata.setMojos( mojos );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "mojo".equals( parser.getName() ) )
                    {
                        mojos.add( parseMojo( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return pluginMetadata;
    } //-- PluginMetadata parsePluginMetadata( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser
     * @param strict
     * @throws IOException
     * @throws XmlPullParserException
     * @return PluginMetadata
     */
    private PluginMetadata read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.getEventType();
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "pluginMetadata".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'pluginMetadata' but found '" + parser.getName() + "'", parser, null );
                }
                PluginMetadata pluginMetadata = parsePluginMetadata( parser, strict );
                pluginMetadata.setModelEncoding( parser.getInputEncoding() );
                return pluginMetadata;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException( "Expected root element 'pluginMetadata' but found no element at all: invalid XML document", parser, null );
    } //-- PluginMetadata read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

}
