/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.codehaus.plexus.velocity.VelocityComponent;

public class PluginHelpGenerator
extends AbstractLogEnabled {
    private static final String HELP_MOJO_CLASS_NAME = "HelpMojo";
    private String helpPackageName;
    private String goalPrefix;
    private MavenProject mavenProject;
    private VelocityComponent velocityComponent;

    public PluginHelpGenerator() {
        this.enableLogging((Logger)new ConsoleLogger(1, "PluginHelpGenerator"));
    }

    public void execute(File destinationDirectory) throws GeneratorException {
        String helpImplementation = this.getImplementation();
        try {
            String sourcePath = helpImplementation.replace('.', File.separatorChar) + ".java";
            File helpClass = new File(destinationDirectory, sourcePath);
            helpClass.getParentFile().mkdirs();
            String helpClassSources = this.getHelpClassSources(PluginHelpGenerator.getPluginHelpPath(this.mavenProject));
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new CachingOutputStream(helpClass), StandardCharsets.UTF_8);){
                w.write(helpClassSources);
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    public PluginHelpGenerator setHelpPackageName(String helpPackageName) {
        this.helpPackageName = helpPackageName;
        return this;
    }

    public PluginHelpGenerator setVelocityComponent(VelocityComponent velocityComponent) {
        this.velocityComponent = velocityComponent;
        return this;
    }

    public PluginHelpGenerator setGoalPrefix(String goalPrefix) {
        this.goalPrefix = goalPrefix;
        return this;
    }

    public PluginHelpGenerator setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        return this;
    }

    private String getHelpClassSources(String pluginHelpPath) throws IOException {
        VelocityContext context = new VelocityContext();
        boolean useAnnotations = this.mavenProject.getArtifactMap().containsKey("org.apache.maven.plugin-tools:maven-plugin-annotations");
        context.put("helpPackageName", (Object)this.helpPackageName);
        context.put("pluginHelpPath", (Object)pluginHelpPath);
        context.put("artifactId", (Object)this.mavenProject.getArtifactId());
        context.put("goalPrefix", (Object)this.goalPrefix);
        context.put("useAnnotations", (Object)useAnnotations);
        StringWriter stringWriter = new StringWriter();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("help-class-source.vm");
             InputStreamReader isReader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            this.velocityComponent.getEngine().evaluate((Context)context, (Writer)stringWriter, "", (Reader)isReader);
        }
        return stringWriter.toString().replaceAll("(\r\n|\n|\r)", System.lineSeparator());
    }

    private String getImplementation() {
        return StringUtils.isEmpty((String)this.helpPackageName) ? HELP_MOJO_CLASS_NAME : this.helpPackageName + '.' + HELP_MOJO_CLASS_NAME;
    }

    static String getPluginHelpPath(MavenProject mavenProject) {
        return mavenProject.getGroupId() + "/" + mavenProject.getArtifactId() + "/plugin-help.xml";
    }
}

