/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin;

import java.lang.reflect.Method;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.ExtendedPluginDescriptor;

public class PluginDescriptorHelper {
    private static final Method GET_REQUIRED_JAVA_VERSION_METHOD;
    private static final Method SET_REQUIRED_JAVA_VERSION_METHOD;

    public static String getRequiredJavaVersion(PluginDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (GET_REQUIRED_JAVA_VERSION_METHOD != null) {
            try {
                return (String)GET_REQUIRED_JAVA_VERSION_METHOD.invoke((Object)descriptor, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (descriptor instanceof ExtendedPluginDescriptor) {
            return ((ExtendedPluginDescriptor)descriptor).getRequiredJavaVersion();
        }
        return null;
    }

    public static PluginDescriptor setRequiredJavaVersion(PluginDescriptor descriptor, String requiredJavaVersion) {
        if (descriptor == null) {
            return null;
        }
        if (SET_REQUIRED_JAVA_VERSION_METHOD != null) {
            try {
                SET_REQUIRED_JAVA_VERSION_METHOD.invoke((Object)descriptor, requiredJavaVersion);
                return descriptor;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(descriptor instanceof ExtendedPluginDescriptor)) {
            descriptor = new ExtendedPluginDescriptor(descriptor);
        }
        ((ExtendedPluginDescriptor)descriptor).setRequiredJavaVersion(requiredJavaVersion);
        return descriptor;
    }

    static {
        Method getMethod = null;
        Method setMethod = null;
        try {
            getMethod = PluginDescriptor.class.getMethod("getRequiredJavaVersion", new Class[0]);
            setMethod = PluginDescriptor.class.getMethod("setRequiredJavaVersion", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        GET_REQUIRED_JAVA_VERSION_METHOD = getMethod;
        SET_REQUIRED_JAVA_VERSION_METHOD = setMethod;
    }
}

