/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.SortedClassLibraryBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.InvalidParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.tools.plugin.ExtendedMojoDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.GroupKey;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavaClassConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavadocBlockTagsToXhtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.converter.JavadocInlineTagsToXhtmlConverter;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ComponentAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ExecuteAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.MojoAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ParameterAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScannerRequest;
import org.apache.maven.tools.plugin.javadoc.JavadocLinkGenerator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Named(value="java-annotations")
@Singleton
public class JavaAnnotationsMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    public static final String NAME = "java-annotations";
    private static final GroupKey GROUP_KEY = new GroupKey("java", 100);
    @Inject
    private MojoAnnotationsScanner mojoAnnotationsScanner;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ArchiverManager archiverManager;
    @Inject
    private JavadocInlineTagsToXhtmlConverter javadocInlineTagsToHtmlConverter;
    @Inject
    private JavadocBlockTagsToXhtmlConverter javadocBlockTagsToHtmlConverter;

    public String getName() {
        return NAME;
    }

    public boolean isDeprecated() {
        return false;
    }

    public GroupKey getGroupKey() {
        return GROUP_KEY;
    }

    public List<MojoDescriptor> execute(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Map<String, MojoAnnotatedClass> mojoAnnotatedClasses = this.scanAnnotations(request);
        JavaProjectBuilder builder = this.scanJavadoc(request, mojoAnnotatedClasses.values());
        Map<String, JavaClass> javaClassesMap = this.discoverClasses(builder);
        JavadocLinkGenerator linkGenerator = request.getInternalJavadocBaseUrl() != null || request.getExternalJavadocBaseUrls() != null && !request.getExternalJavadocBaseUrls().isEmpty() ? new JavadocLinkGenerator(request.getInternalJavadocBaseUrl(), request.getInternalJavadocVersion(), request.getExternalJavadocBaseUrls(), request.getSettings()) : null;
        this.populateDataFromJavadoc(builder, mojoAnnotatedClasses, javaClassesMap, linkGenerator);
        return this.toMojoDescriptors(mojoAnnotatedClasses, request.getPluginDescriptor());
    }

    private Map<String, MojoAnnotatedClass> scanAnnotations(PluginToolsRequest request) throws ExtractionException {
        MojoAnnotationsScannerRequest mojoAnnotationsScannerRequest = new MojoAnnotationsScannerRequest();
        File output = new File(request.getProject().getBuild().getOutputDirectory());
        mojoAnnotationsScannerRequest.setClassesDirectories(Arrays.asList(output));
        mojoAnnotationsScannerRequest.setDependencies(request.getDependencies());
        mojoAnnotationsScannerRequest.setProject(request.getProject());
        return this.mojoAnnotationsScanner.scan(mojoAnnotationsScannerRequest);
    }

    private JavaProjectBuilder scanJavadoc(PluginToolsRequest request, Collection<MojoAnnotatedClass> mojoAnnotatedClasses) throws ExtractionException {
        ArrayList<MavenProject> mavenProjects = new ArrayList<MavenProject>();
        HashSet<Artifact> externalArtifacts = new HashSet<Artifact>();
        JavaProjectBuilder builder = new JavaProjectBuilder((ClassLibraryBuilder)new SortedClassLibraryBuilder());
        builder.setEncoding(request.getEncoding());
        this.extendJavaProjectBuilder(builder, request.getProject());
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses) {
            if (Objects.equals(mojoAnnotatedClass.getArtifact().getArtifactId(), request.getProject().getArtifact().getArtifactId()) || !this.isMojoAnnnotatedClassCandidate(mojoAnnotatedClass)) continue;
            MavenProject mavenProject = this.getFromProjectReferences(mojoAnnotatedClass.getArtifact(), request.getProject());
            if (mavenProject != null) {
                mavenProjects.add(mavenProject);
                continue;
            }
            externalArtifacts.add(mojoAnnotatedClass.getArtifact());
        }
        for (Artifact artifact : externalArtifacts) {
            if (StringUtils.equalsIgnoreCase((String)"tests", (String)artifact.getClassifier())) {
                this.extendJavaProjectBuilderWithSourcesJar(builder, artifact, request, "test-sources");
                continue;
            }
            this.extendJavaProjectBuilderWithSourcesJar(builder, artifact, request, "sources");
        }
        for (MavenProject mavenProject : mavenProjects) {
            this.extendJavaProjectBuilder(builder, mavenProject);
        }
        return builder;
    }

    private boolean isMojoAnnnotatedClassCandidate(MojoAnnotatedClass mojoAnnotatedClass) {
        return mojoAnnotatedClass != null && mojoAnnotatedClass.hasAnnotations();
    }

    protected void populateDataFromJavadoc(JavaProjectBuilder javaProjectBuilder, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, Map<String, JavaClass> javaClassesMap, JavadocLinkGenerator linkGenerator) {
        for (Map.Entry<String, MojoAnnotatedClass> entry : mojoAnnotatedClasses.entrySet()) {
            JavaClass javaClass = javaClassesMap.get(entry.getKey());
            if (javaClass == null) continue;
            MojoAnnotationContent mojoAnnotationContent = entry.getValue().getMojo();
            if (mojoAnnotationContent != null) {
                DocletTag deprecated;
                JavaClassConverterContext context = new JavaClassConverterContext(javaClass, javaProjectBuilder, mojoAnnotatedClasses, linkGenerator, javaClass.getLineNumber());
                mojoAnnotationContent.setDescription(this.getDescriptionFromElement((JavaAnnotatedElement)javaClass, context));
                DocletTag since = this.findInClassHierarchy(javaClass, "since");
                if (since != null) {
                    mojoAnnotationContent.setSince(this.getRawValueFromTaglet(since, context));
                }
                if ((deprecated = this.findInClassHierarchy(javaClass, "deprecated")) != null) {
                    mojoAnnotationContent.setDeprecated(this.getRawValueFromTaglet(deprecated, context));
                }
            }
            Map<String, JavaAnnotatedElement> fieldsMap = this.extractFieldsAnnotations(javaClass, javaClassesMap);
            Map<String, JavaAnnotatedElement> methodsMap = this.extractMethodsAnnotations(javaClass, javaClassesMap);
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(entry.getValue(), mojoAnnotatedClasses);
            parameters = new TreeMap<String, ParameterAnnotationContent>(parameters);
            for (Map.Entry<String, ParameterAnnotationContent> parameter : parameters.entrySet()) {
                DocletTag since;
                JavaAnnotatedElement element = parameter.getValue().isAnnotationOnMethod() ? methodsMap.get(parameter.getKey()) : fieldsMap.get(parameter.getKey());
                if (element == null) continue;
                JavaClassConverterContext context = new JavaClassConverterContext(javaClass, ((JavaMember)element).getDeclaringClass(), javaProjectBuilder, mojoAnnotatedClasses, linkGenerator, element.getLineNumber());
                ParameterAnnotationContent parameterAnnotationContent = parameter.getValue();
                parameterAnnotationContent.setDescription(this.getDescriptionFromElement(element, context));
                DocletTag deprecated = element.getTagByName("deprecated");
                if (deprecated != null) {
                    parameterAnnotationContent.setDeprecated(this.getRawValueFromTaglet(deprecated, context));
                }
                if ((since = element.getTagByName("since")) == null) continue;
                parameterAnnotationContent.setSince(this.getRawValueFromTaglet(since, context));
            }
            Map<String, ComponentAnnotationContent> components = entry.getValue().getComponents();
            for (Map.Entry<String, ComponentAnnotationContent> component : components.entrySet()) {
                DocletTag since;
                JavaAnnotatedElement element = fieldsMap.get(component.getKey());
                if (element == null) continue;
                JavaClassConverterContext context = new JavaClassConverterContext(javaClass, ((JavaMember)element).getDeclaringClass(), javaProjectBuilder, mojoAnnotatedClasses, linkGenerator, javaClass.getLineNumber());
                ComponentAnnotationContent componentAnnotationContent = component.getValue();
                componentAnnotationContent.setDescription(this.getDescriptionFromElement(element, context));
                DocletTag deprecated = element.getTagByName("deprecated");
                if (deprecated != null) {
                    componentAnnotationContent.setDeprecated(this.getRawValueFromTaglet(deprecated, context));
                }
                if ((since = element.getTagByName("since")) == null) continue;
                componentAnnotationContent.setSince(this.getRawValueFromTaglet(since, context));
            }
        }
    }

    String getDescriptionFromElement(JavaAnnotatedElement element, JavaClassConverterContext context) {
        String comment = element.getComment();
        if (comment == null) {
            return null;
        }
        StringBuilder description = new StringBuilder(this.javadocInlineTagsToHtmlConverter.convert(comment, context));
        for (DocletTag docletTag : element.getTags()) {
            if (!"see".equals(docletTag.getName())) continue;
            description.append(this.javadocBlockTagsToHtmlConverter.convert(docletTag, context));
        }
        return description.toString();
    }

    String getRawValueFromTaglet(DocletTag docletTag, ConverterContext context) {
        return this.javadocInlineTagsToHtmlConverter.convert(docletTag.getValue(), context);
    }

    private DocletTag findInClassHierarchy(JavaClass javaClass, String tagName) {
        try {
            JavaClass superClass;
            DocletTag tag = javaClass.getTagByName(tagName);
            if (tag == null && (superClass = javaClass.getSuperJavaClass()) != null) {
                tag = this.findInClassHierarchy(superClass, tagName);
            }
            return tag;
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().warn("Failed extracting tag '" + tagName + "' from class " + javaClass);
            throw e;
        }
    }

    private Map<String, JavaAnnotatedElement> extractFieldsAnnotations(JavaClass javaClass, Map<String, JavaClass> javaClassesMap) {
        try {
            Map<Object, Object> rawParams = new TreeMap();
            JavaClass superClass = javaClass.getSuperJavaClass();
            if (superClass != null) {
                if (!superClass.getFields().isEmpty()) {
                    rawParams = this.extractFieldsAnnotations(superClass, javaClassesMap);
                }
                if ((superClass = javaClassesMap.get(superClass.getFullyQualifiedName())) != null && !superClass.getFields().isEmpty()) {
                    rawParams = this.extractFieldsAnnotations(superClass, javaClassesMap);
                }
            } else {
                rawParams = new TreeMap();
            }
            for (JavaField field : javaClass.getFields()) {
                rawParams.put(field.getName(), (JavaAnnotatedElement)field);
            }
            return rawParams;
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().warn("Failed extracting parameters from " + javaClass);
            throw e;
        }
    }

    private Map<String, JavaAnnotatedElement> extractMethodsAnnotations(JavaClass javaClass, Map<String, JavaClass> javaClassesMap) {
        try {
            Map<Object, Object> rawParams = new TreeMap();
            JavaClass superClass = javaClass.getSuperJavaClass();
            if (superClass != null) {
                if (!superClass.getMethods().isEmpty()) {
                    rawParams = this.extractMethodsAnnotations(superClass, javaClassesMap);
                }
                if ((superClass = javaClassesMap.get(superClass.getFullyQualifiedName())) != null && !superClass.getMethods().isEmpty()) {
                    rawParams = this.extractMethodsAnnotations(superClass, javaClassesMap);
                }
            } else {
                rawParams = new TreeMap();
            }
            for (JavaMethod method : javaClass.getMethods()) {
                if (!this.isPublicSetterMethod(method)) continue;
                rawParams.put(StringUtils.lowercaseFirstLetter((String)method.getName().substring(3)), (JavaAnnotatedElement)method);
            }
            return rawParams;
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().warn("Failed extracting methods from " + javaClass);
            throw e;
        }
    }

    private boolean isPublicSetterMethod(JavaMethod method) {
        return method.isPublic() && !method.isStatic() && method.getName().length() > 3 && (method.getName().startsWith("add") || method.getName().startsWith("set")) && "void".equals(method.getReturnType().getValue()) && method.getParameters().size() == 1;
    }

    protected Map<String, JavaClass> discoverClasses(JavaProjectBuilder builder) {
        Collection javaClasses = builder.getClasses();
        if (javaClasses == null || javaClasses.size() < 1) {
            return Collections.emptyMap();
        }
        HashMap<String, JavaClass> javaClassMap = new HashMap<String, JavaClass>(javaClasses.size());
        for (JavaClass javaClass : javaClasses) {
            javaClassMap.put(javaClass.getFullyQualifiedName(), javaClass);
        }
        return javaClassMap;
    }

    protected void extendJavaProjectBuilderWithSourcesJar(JavaProjectBuilder builder, Artifact artifact, PluginToolsRequest request, String classifier) throws ExtractionException {
        try {
            Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), classifier);
            ArtifactResolutionRequest req = new ArtifactResolutionRequest();
            req.setArtifact(sourcesArtifact);
            req.setLocalRepository(request.getLocal());
            req.setRemoteRepositories(request.getRemoteRepos());
            ArtifactResolutionResult res = this.repositorySystem.resolve(req);
            if (res.hasMissingArtifacts() || res.hasExceptions()) {
                this.getLogger().warn("Unable to get sources artifact for " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ". Some javadoc tags (@since, @deprecated and comments) won't be used");
                return;
            }
            if (sourcesArtifact.getFile() == null || !sourcesArtifact.getFile().exists()) {
                return;
            }
            if (sourcesArtifact.getFile().isFile()) {
                File extractDirectory = new File(request.getProject().getBuild().getDirectory(), "maven-plugin-plugin-sources/" + sourcesArtifact.getGroupId() + "/" + sourcesArtifact.getArtifactId() + "/" + sourcesArtifact.getVersion() + "/" + sourcesArtifact.getClassifier());
                extractDirectory.mkdirs();
                UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
                unArchiver.setSourceFile(sourcesArtifact.getFile());
                unArchiver.setDestDirectory(extractDirectory);
                unArchiver.extract();
                this.extendJavaProjectBuilder(builder, Arrays.asList(extractDirectory), request.getDependencies());
            } else if (sourcesArtifact.getFile().isDirectory()) {
                this.extendJavaProjectBuilder(builder, Arrays.asList(sourcesArtifact.getFile()), request.getDependencies());
            }
        }
        catch (ArchiverException | NoSuchArchiverException e) {
            throw new ExtractionException(e.getMessage(), e);
        }
    }

    private void extendJavaProjectBuilder(JavaProjectBuilder builder, MavenProject project) {
        ArrayList<File> sources = new ArrayList<File>();
        for (String source : project.getCompileSourceRoots()) {
            sources.add(new File(source));
        }
        File generatedPlugin = new File(project.getBasedir(), "target/generated-sources/plugin");
        if (!project.getCompileSourceRoots().contains(generatedPlugin.getAbsolutePath()) && generatedPlugin.exists()) {
            sources.add(generatedPlugin);
        }
        this.extendJavaProjectBuilder(builder, sources, project.getArtifacts());
    }

    private void extendJavaProjectBuilder(JavaProjectBuilder builder, List<File> sourceDirectories, Set<Artifact> artifacts) {
        ArrayList<URL> urls = new ArrayList<URL>(artifacts.size());
        for (Artifact artifact : artifacts) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        builder.addClassLoader((ClassLoader)new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
        for (File source : sourceDirectories) {
            builder.addSourceTree(source);
        }
    }

    private List<MojoDescriptor> toMojoDescriptors(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, PluginDescriptor pluginDescriptor) throws DuplicateParameterException, InvalidParameterException {
        ArrayList<MojoDescriptor> mojoDescriptors = new ArrayList<MojoDescriptor>(mojoAnnotatedClasses.size());
        for (MojoAnnotatedClass mojoAnnotatedClass : mojoAnnotatedClasses.values()) {
            if (mojoAnnotatedClass.getMojo() == null) continue;
            ExtendedMojoDescriptor mojoDescriptor = new ExtendedMojoDescriptor(true);
            mojoDescriptor.setImplementation(mojoAnnotatedClass.getClassName());
            mojoDescriptor.setLanguage("java");
            MojoAnnotationContent mojo = mojoAnnotatedClass.getMojo();
            mojoDescriptor.setDescription(mojo.getDescription());
            mojoDescriptor.setSince(mojo.getSince());
            mojo.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setProjectRequired(mojo.requiresProject());
            mojoDescriptor.setRequiresReports(mojo.requiresReports());
            mojoDescriptor.setComponentConfigurator(mojo.configurator());
            mojoDescriptor.setInheritedByDefault(mojo.inheritByDefault());
            mojoDescriptor.setInstantiationStrategy(mojo.instantiationStrategy().id());
            mojoDescriptor.setAggregator(mojo.aggregator());
            mojoDescriptor.setDependencyResolutionRequired(mojo.requiresDependencyResolution().id());
            mojoDescriptor.setDependencyCollectionRequired(mojo.requiresDependencyCollection().id());
            mojoDescriptor.setDirectInvocationOnly(mojo.requiresDirectInvocation());
            mojoDescriptor.setDeprecated(mojo.getDeprecated());
            mojoDescriptor.setThreadSafe(mojo.threadSafe());
            ExecuteAnnotationContent execute = this.findExecuteInParentHierarchy(mojoAnnotatedClass, mojoAnnotatedClasses);
            if (execute != null) {
                mojoDescriptor.setExecuteGoal(execute.goal());
                mojoDescriptor.setExecuteLifecycle(execute.lifecycle());
                if (execute.phase() != null) {
                    mojoDescriptor.setExecutePhase(execute.phase().id());
                }
            }
            mojoDescriptor.setExecutionStrategy(mojo.executionStrategy());
            mojoDescriptor.setGoal(mojo.name());
            mojoDescriptor.setOnlineRequired(mojo.requiresOnline());
            mojoDescriptor.setPhase(mojo.defaultPhase().id());
            Map<String, ParameterAnnotationContent> parameters = this.getParametersParentHierarchy(mojoAnnotatedClass, mojoAnnotatedClasses);
            for (ParameterAnnotationContent parameterAnnotationContent : new TreeSet<ParameterAnnotationContent>(parameters.values())) {
                Parameter parameter = new Parameter();
                String name = StringUtils.isEmpty((String)parameterAnnotationContent.name()) ? parameterAnnotationContent.getFieldName() : parameterAnnotationContent.name();
                parameter.setName(name);
                parameter.setAlias(parameterAnnotationContent.alias());
                parameter.setDefaultValue(parameterAnnotationContent.defaultValue());
                parameter.setDeprecated(parameterAnnotationContent.getDeprecated());
                parameter.setDescription(parameterAnnotationContent.getDescription());
                parameter.setEditable(!parameterAnnotationContent.readonly());
                String property = parameterAnnotationContent.property();
                if (StringUtils.contains((String)property, (char)'$') || StringUtils.contains((String)property, (char)'{') || StringUtils.contains((String)property, (char)'}')) {
                    throw new InvalidParameterException("Invalid property for parameter '" + parameter.getName() + "', forbidden characters ${}: " + property, null);
                }
                parameter.setExpression(StringUtils.isEmpty((String)property) ? "" : "${" + property + "}");
                StringBuilder type = new StringBuilder(parameterAnnotationContent.getClassName());
                if (!parameterAnnotationContent.getTypeParameters().isEmpty()) {
                    type.append(parameterAnnotationContent.getTypeParameters().stream().collect(Collectors.joining(", ", "<", ">")));
                }
                parameter.setType(type.toString());
                parameter.setSince(parameterAnnotationContent.getSince());
                parameter.setRequired(parameterAnnotationContent.required());
                mojoDescriptor.addParameter(parameter);
            }
            Map<String, ComponentAnnotationContent> components = this.getComponentsParentHierarchy(mojoAnnotatedClass, mojoAnnotatedClasses);
            for (ComponentAnnotationContent componentAnnotationContent : new TreeSet<ComponentAnnotationContent>(components.values())) {
                Parameter parameter = new Parameter();
                parameter.setName(componentAnnotationContent.getFieldName());
                String expression = (String)PluginUtils.MAVEN_COMPONENTS.get(componentAnnotationContent.getRoleClassName());
                if (expression == null) {
                    parameter.setRequirement(new Requirement(componentAnnotationContent.getRoleClassName(), componentAnnotationContent.hint()));
                } else {
                    this.getLogger().warn("Deprecated @Component annotation for '" + parameter.getName() + "' field in " + mojoAnnotatedClass.getClassName() + ": replace with @Parameter( defaultValue = \"" + expression + "\", readonly = true )");
                    parameter.setDefaultValue(expression);
                    parameter.setType(componentAnnotationContent.getRoleClassName());
                    parameter.setRequired(true);
                }
                parameter.setDeprecated(componentAnnotationContent.getDeprecated());
                parameter.setSince(componentAnnotationContent.getSince());
                parameter.setEditable(false);
                mojoDescriptor.addParameter(parameter);
            }
            mojoDescriptor.setPluginDescriptor(pluginDescriptor);
            mojoDescriptors.add((MojoDescriptor)mojoDescriptor);
        }
        return mojoDescriptors;
    }

    protected ExecuteAnnotationContent findExecuteInParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        if (mojoAnnotatedClass.getExecute() != null) {
            return mojoAnnotatedClass.getExecute();
        }
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (StringUtils.isEmpty((String)parentClassName)) {
            return null;
        }
        MojoAnnotatedClass parent = mojoAnnotatedClasses.get(parentClassName);
        if (parent == null) {
            return null;
        }
        return this.findExecuteInParentHierarchy(parent, mojoAnnotatedClasses);
    }

    protected Map<String, ParameterAnnotationContent> getParametersParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ParameterAnnotationContent> parameterAnnotationContents = new ArrayList<ParameterAnnotationContent>();
        parameterAnnotationContents = this.getParametersParent(mojoAnnotatedClass, parameterAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(parameterAnnotationContents);
        HashMap<String, ParameterAnnotationContent> map = new HashMap<String, ParameterAnnotationContent>(parameterAnnotationContents.size());
        for (ParameterAnnotationContent parameterAnnotationContent : parameterAnnotationContents) {
            map.put(parameterAnnotationContent.getFieldName(), parameterAnnotationContent);
        }
        return map;
    }

    protected List<ParameterAnnotationContent> getParametersParent(MojoAnnotatedClass mojoAnnotatedClass, List<ParameterAnnotationContent> parameterAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        parameterAnnotationContents.addAll(mojoAnnotatedClass.getParameters().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getParametersParent(parent, parameterAnnotationContents, mojoAnnotatedClasses);
        }
        return parameterAnnotationContents;
    }

    protected Map<String, ComponentAnnotationContent> getComponentsParentHierarchy(MojoAnnotatedClass mojoAnnotatedClass, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        List<ComponentAnnotationContent> componentAnnotationContents = new ArrayList<ComponentAnnotationContent>();
        componentAnnotationContents = this.getComponentParent(mojoAnnotatedClass, componentAnnotationContents, mojoAnnotatedClasses);
        Collections.reverse(componentAnnotationContents);
        HashMap<String, ComponentAnnotationContent> map = new HashMap<String, ComponentAnnotationContent>(componentAnnotationContents.size());
        for (ComponentAnnotationContent componentAnnotationContent : componentAnnotationContents) {
            map.put(componentAnnotationContent.getFieldName(), componentAnnotationContent);
        }
        return map;
    }

    protected List<ComponentAnnotationContent> getComponentParent(MojoAnnotatedClass mojoAnnotatedClass, List<ComponentAnnotationContent> componentAnnotationContents, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses) {
        MojoAnnotatedClass parent;
        componentAnnotationContents.addAll(mojoAnnotatedClass.getComponents().values());
        String parentClassName = mojoAnnotatedClass.getParentClassName();
        if (parentClassName != null && (parent = mojoAnnotatedClasses.get(parentClassName)) != null) {
            return this.getComponentParent(parent, componentAnnotationContents, mojoAnnotatedClasses);
        }
        return componentAnnotationContents;
    }

    protected MavenProject getFromProjectReferences(Artifact artifact, MavenProject project) {
        if (project.getProjectReferences() == null || project.getProjectReferences().isEmpty()) {
            return null;
        }
        Collection mavenProjects = project.getProjectReferences().values();
        for (MavenProject mavenProject : mavenProjects) {
            if (!Objects.equals(mavenProject.getId(), artifact.getId())) continue;
            return mavenProject;
        }
        return null;
    }
}

