/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.internal.ProviderMethodsModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.plugin.testing.Basedir;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoParameter;
import org.apache.maven.api.plugin.testing.MojoParameters;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.testing.MojoLogWrapper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.testing.PlexusExtension;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class MojoExtension
extends PlexusExtension
implements ParameterResolver {
    private static final ExtensionContext.Namespace MOJO_EXTENSION = ExtensionContext.Namespace.create((Object[])new Object[]{"MojoExtension"});
    public static final String BASEDIR_IS_SET_KEY = "basedirIsSet";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(InjectMojo.class) || parameterContext.getDeclaringExecutable().isAnnotationPresent(InjectMojo.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            InjectMojo injectMojo = parameterContext.findAnnotation(InjectMojo.class).orElseGet(() -> parameterContext.getDeclaringExecutable().getAnnotation(InjectMojo.class));
            HashSet<MojoParameter> mojoParameters = new HashSet<MojoParameter>(parameterContext.findRepeatableAnnotations(MojoParameter.class));
            Optional.ofNullable(parameterContext.getDeclaringExecutable().getAnnotation(MojoParameter.class)).ifPresent(mojoParameters::add);
            Optional.ofNullable(parameterContext.getDeclaringExecutable().getAnnotation(MojoParameters.class)).map(MojoParameters::value).map(Arrays::asList).ifPresent(mojoParameters::addAll);
            Class<?> holder = parameterContext.getTarget().get().getClass();
            PluginDescriptor descriptor = (PluginDescriptor)extensionContext.getStore(MOJO_EXTENSION).get(PluginDescriptor.class, PluginDescriptor.class);
            return this.lookupMojo(extensionContext, holder, injectMojo, mojoParameters, descriptor);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Unable to resolve parameter", (Throwable)e);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        String basedir = AnnotationSupport.findAnnotation((AnnotatedElement)((AnnotatedElement)context.getElement().get()), Basedir.class).map(Basedir::value).orElse(null);
        if (basedir == null) {
            basedir = MojoExtension.getBasedir();
        } else {
            context.getStore(MOJO_EXTENSION).put((Object)BASEDIR_IS_SET_KEY, (Object)Boolean.TRUE);
        }
        URL resource = context.getRequiredTestClass().getResource(basedir);
        if (resource != null) {
            basedir = Paths.get(resource.toURI()).toString();
        }
        basedir = new File(basedir).getAbsolutePath();
        this.setTestBasedir(basedir, context);
        PlexusContainer plexusContainer = this.getContainer(context);
        ((DefaultPlexusContainer)plexusContainer).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> {
            binder.install(ProviderMethodsModule.forObject((Object)context.getRequiredTestInstance()));
            binder.install((Module)new MavenProvidesModule(context.getRequiredTestInstance()));
        }});
        this.addMock(plexusContainer, Log.class, () -> new MojoLogWrapper(LoggerFactory.getLogger((String)"anonymous")));
        MavenProject mavenProject = this.addMock(plexusContainer, MavenProject.class, this::mockMavenProject);
        MojoExecution mojoExecution = this.addMock(plexusContainer, MojoExecution.class, this::mockMojoExecution);
        MavenSession mavenSession = this.addMock(plexusContainer, MavenSession.class, this::mockMavenSession);
        SessionScope sessionScope = (SessionScope)plexusContainer.lookup(SessionScope.class);
        sessionScope.enter();
        sessionScope.seed(MavenSession.class, (Object)mavenSession);
        MojoExecutionScope executionScope = (MojoExecutionScope)plexusContainer.lookup(MojoExecutionScope.class);
        executionScope.enter();
        executionScope.seed(MavenProject.class, (Object)mavenProject);
        executionScope.seed(MojoExecution.class, (Object)mojoExecution);
        ((DefaultPlexusContainer)plexusContainer).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> binder.requestInjection(context.getRequiredTestInstance())});
        Map map = plexusContainer.getContext().getContextData();
        ClassLoader classLoader = context.getRequiredTestClass().getClassLoader();
        try (InputStream is = Objects.requireNonNull(classLoader.getResourceAsStream(this.getPluginDescriptorLocation()), "Unable to find plugin descriptor: " + this.getPluginDescriptorLocation());
             BufferedReader reader = new BufferedReader((Reader)new XmlStreamReader(is));
             InterpolationFilterReader interpolationReader = new InterpolationFilterReader((Reader)reader, map, "${", "}");){
            PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationReader);
            context.getStore(MOJO_EXTENSION).put(PluginDescriptor.class, (Object)pluginDescriptor);
            for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
                plexusContainer.addComponentDescriptor(desc);
            }
        }
    }

    private <T> T addMock(PlexusContainer container, Class<T> role, Supplier<T> supplier) throws ComponentLookupException {
        if (!container.hasComponent(role)) {
            T mock = supplier.get();
            container.addComponent(mock, role, "default");
            return mock;
        }
        return (T)container.lookup(role);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        SessionScope sessionScope = (SessionScope)this.getContainer(context).lookup(SessionScope.class);
        sessionScope.exit();
        MojoExecutionScope executionScope = (MojoExecutionScope)this.getContainer(context).lookup(MojoExecutionScope.class);
        executionScope.exit();
        super.afterEach(context);
    }

    private MojoExecution mockMojoExecution() {
        return (MojoExecution)Mockito.mock(MojoExecution.class);
    }

    private MavenSession mockMavenSession() {
        MavenSession session = (MavenSession)Mockito.mock(MavenSession.class);
        Mockito.lenient().when((Object)session.getUserProperties()).thenReturn((Object)new Properties());
        Mockito.lenient().when((Object)session.getSystemProperties()).thenReturn((Object)new Properties());
        return session;
    }

    private MavenProject mockMavenProject() {
        MavenProject mavenProject = (MavenProject)Mockito.mock(MavenProject.class);
        Mockito.lenient().when((Object)mavenProject.getProperties()).thenReturn((Object)new Properties());
        return mavenProject;
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private Mojo lookupMojo(ExtensionContext extensionContext, Class<?> holder, InjectMojo injectMojo, Collection<MojoParameter> mojoParameters, PluginDescriptor descriptor) throws Exception {
        Xpp3Dom pomDom;
        Path path;
        String goal = injectMojo.goal();
        String pom = injectMojo.pom();
        Path basedir = Paths.get(this.getTestBasedir(extensionContext), new String[0]);
        String[] coord = this.mojoCoordinates(goal, descriptor);
        if (pom.startsWith("file:")) {
            path = basedir.resolve(pom.substring("file:".length()));
            pomDom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(path.toFile()));
        } else if (pom.startsWith("classpath:")) {
            URL url = holder.getResource(pom.substring("classpath:".length()));
            if (url == null) {
                throw new IllegalStateException("Unable to find pom on classpath: " + pom);
            }
            pomDom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(url.openStream()));
        } else if (pom.contains("<project>")) {
            pomDom = Xpp3DomBuilder.build((Reader)new StringReader(pom));
        } else if (!pom.isEmpty()) {
            path = basedir.resolve(pom);
            pomDom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(path.toFile()));
        } else {
            pomDom = this.isBasedirSet(extensionContext) ? (Files.exists(path = basedir.resolve("pom.xml"), new LinkOption[0]) ? Xpp3DomBuilder.build((Reader)new XmlStreamReader(path.toFile())) : new Xpp3Dom("")) : new Xpp3Dom("");
        }
        Xpp3Dom pluginConfiguration = MojoExtension.extractPluginConfiguration(coord[1], pomDom);
        if (!mojoParameters.isEmpty()) {
            List<Xpp3Dom> children = mojoParameters.stream().map(mp -> {
                Xpp3Dom c = new Xpp3Dom(mp.name());
                c.setValue(mp.value());
                return c;
            }).collect(Collectors.toList());
            Xpp3Dom config = new Xpp3Dom("configuration");
            children.forEach(arg_0 -> ((Xpp3Dom)config).addChild(arg_0));
            pluginConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)config, (Xpp3Dom)pluginConfiguration);
        }
        return this.lookupMojo(extensionContext, coord, pluginConfiguration, descriptor);
    }

    private boolean isBasedirSet(ExtensionContext extensionContext) {
        return (Boolean)extensionContext.getStore(MOJO_EXTENSION).getOrDefault((Object)BASEDIR_IS_SET_KEY, Boolean.class, (Object)Boolean.FALSE);
    }

    protected String[] mojoCoordinates(String goal, PluginDescriptor pluginDescriptor) throws Exception {
        if (goal.matches(".*:.*:.*:.*")) {
            return goal.split(":");
        }
        String artifactId = pluginDescriptor.getArtifactId();
        String groupId = pluginDescriptor.getGroupId();
        String version = pluginDescriptor.getVersion();
        return new String[]{groupId, artifactId, version, goal};
    }

    protected Mojo lookupMojo(ExtensionContext extensionContext, String[] coord, Xpp3Dom pluginConfiguration, PluginDescriptor descriptor) throws Exception {
        PlexusContainer plexusContainer = this.getContainer(extensionContext);
        Mojo mojo = (Mojo)plexusContainer.lookup(Mojo.class, coord[0] + ":" + coord[1] + ":" + coord[2] + ":" + coord[3]);
        Optional<MojoDescriptor> mojoDescriptor = descriptor.getMojos().stream().filter(md -> Objects.equals(md.getImplementation(), mojo.getClass().getName())).findFirst();
        if (mojoDescriptor.isPresent()) {
            pluginConfiguration = this.finalizeConfig(pluginConfiguration, mojoDescriptor.get());
        }
        MavenSession session = (MavenSession)plexusContainer.lookup(MavenSession.class);
        MavenProject mavenProject = (MavenProject)plexusContainer.lookup(MavenProject.class);
        MojoExecution mojoExecution = (MojoExecution)plexusContainer.lookup(MojoExecution.class);
        if (Mockito.mockingDetails((Object)session).isMock()) {
            Mockito.lenient().when((Object)session.getCurrentProject()).thenReturn((Object)mavenProject);
        }
        if (Mockito.mockingDetails((Object)mavenProject).isMock()) {
            Mockito.lenient().when((Object)mavenProject.getBasedir()).thenReturn((Object)new File(this.getTestBasedir(extensionContext)));
        }
        if (mojoDescriptor.isPresent() && Mockito.mockingDetails((Object)mojoExecution).isMock()) {
            Mockito.lenient().when((Object)mojoExecution.getMojoDescriptor()).thenReturn((Object)mojoDescriptor.get());
        }
        if (pluginConfiguration != null) {
            WrapEvaluator evaluator = new WrapEvaluator(plexusContainer, (TypeAwareExpressionEvaluator)new PluginParameterExpressionEvaluator(session, mojoExecution));
            BasicComponentConfigurator configurator = new BasicComponentConfigurator();
            configurator.configureComponent((Object)mojo, (PlexusConfiguration)new XmlPlexusConfiguration(pluginConfiguration), (ExpressionEvaluator)evaluator, plexusContainer.getContainerRealm());
        }
        mojo.setLog((Log)plexusContainer.lookup(Log.class));
        if (Mockito.mockingDetails((Object)session).isMock()) {
            Mockito.clearInvocations((Object[])new MavenSession[]{session});
        }
        if (Mockito.mockingDetails((Object)mavenProject).isMock()) {
            Mockito.clearInvocations((Object[])new MavenProject[]{mavenProject});
        }
        if (Mockito.mockingDetails((Object)mojoExecution).isMock()) {
            Mockito.clearInvocations((Object[])new MojoExecution[]{mojoExecution});
        }
        return mojo;
    }

    private Xpp3Dom finalizeConfig(Xpp3Dom config, MojoDescriptor mojoDescriptor) {
        ArrayList<Xpp3Dom> children = new ArrayList<Xpp3Dom>();
        if (mojoDescriptor != null && mojoDescriptor.getParameters() != null) {
            Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = config.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = config.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (this.isEmpty(parameterConfiguration.getAttribute("implementation")) && !this.isEmpty(parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                children.add(parameterConfiguration);
            }
        }
        Xpp3Dom c = new Xpp3Dom("configuration");
        children.forEach(arg_0 -> ((Xpp3Dom)c).addChild(arg_0));
        return c;
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static Optional<Xpp3Dom> child(Xpp3Dom element, String name) {
        return Optional.ofNullable(element.getChild(name));
    }

    private static Stream<Xpp3Dom> children(Xpp3Dom element) {
        return Stream.of(element.getChildren());
    }

    public static Xpp3Dom extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginConfigurationElement = MojoExtension.child(pomDom, "build").flatMap(buildElement -> MojoExtension.child(buildElement, "plugins")).map(MojoExtension::children).orElseGet(Stream::empty).filter(e -> e.getChild("artifactId").getValue().equals(artifactId)).findFirst().flatMap(buildElement -> MojoExtension.child(buildElement, "configuration")).orElse(Xpp3DomBuilder.build((Reader)new StringReader("<configuration/>")));
        return pluginConfigurationElement;
    }

    public static Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return MojoExtension.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(MojoExtension.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    public static String getBasedir() {
        return PlexusExtension.getBasedir();
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        Objects.requireNonNull(field, "Field " + variable + " not found");
        field.setAccessible(true);
        field.set(object, value);
    }

    private static class WrapEvaluator
    implements TypeAwareExpressionEvaluator {
        private final PlexusContainer container;
        private final TypeAwareExpressionEvaluator evaluator;

        WrapEvaluator(PlexusContainer container, TypeAwareExpressionEvaluator evaluator) {
            this.container = container;
            this.evaluator = evaluator;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            String expr;
            Object value = this.evaluator.evaluate(expression, type);
            if (value == null && (expr = this.stripTokens(expression)) != null) {
                try {
                    value = this.container.lookup(type, expr);
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }
            return value;
        }

        private String stripTokens(String expr) {
            if (expr.startsWith("${") && expr.endsWith("}")) {
                return expr.substring(2, expr.length() - 1);
            }
            return null;
        }

        public File alignToBaseDirectory(File path) {
            return this.evaluator.alignToBaseDirectory(path);
        }
    }

    private static class MavenProvidesModule
    implements Module {
        private final Object testInstance;

        MavenProvidesModule(Object testInstance) {
            this.testInstance = testInstance;
        }

        public void configure(Binder binder) {
            List providesMethods = AnnotationSupport.findAnnotatedMethods(this.testInstance.getClass(), Provides.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
            for (Method method : providesMethods) {
                if (method.getParameterCount() > 0) {
                    throw new IllegalArgumentException("Parameterized method are not supported " + method);
                }
                try {
                    method.setAccessible(true);
                    Object value = method.invoke(this.testInstance, new Object[0]);
                    if (value == null) {
                        throw new IllegalArgumentException("Provides method returned null: " + method);
                    }
                    binder.bind(method.getReturnType()).toInstance(value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }
}

