/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.crypto.sha;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.maven.mercury.crypto.api.AbstractStreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierAttributes;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.basic.ChecksumCalculator;

public class SHA1Verifier
extends AbstractStreamVerifier
implements StreamVerifier {
    public static final String digestAlgorithm = "SHA-1";
    private MessageDigest digest;
    private byte[] digestBytes;
    private long length = -1L;
    private String lastModified;
    private String sig;

    public SHA1Verifier(StreamVerifierAttributes attributes) {
        super(attributes);
        try {
            this.digest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    private byte[] getSignatureBytes() {
        if (this.digestBytes == null) {
            this.digestBytes = this.digest.digest();
        }
        return this.digestBytes;
    }

    public String getSignature() {
        return ChecksumCalculator.encodeToAsciiHex(this.getSignatureBytes());
    }

    public void initSignature(String signatureString) throws StreamVerifierException {
        if (signatureString == null || signatureString.length() < 1) {
            throw new IllegalArgumentException("null signature stream");
        }
        this.sig = signatureString;
    }

    public boolean verifySignature() {
        String calculatedSignature = this.getSignature();
        if (calculatedSignature == null && this.sig == null) {
            return true;
        }
        return calculatedSignature != null && calculatedSignature.equals(this.sig);
    }

    public void byteReady(int b) {
        if (this.digest != null) {
            this.digest.update((byte)b);
        }
    }

    public void bytesReady(byte[] b, int off, int len) {
        if (this.digest != null) {
            this.digest.update(b, off, len);
        }
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String time) {
        this.lastModified = time;
    }
}

