/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.crypto.pgp;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class PgpHelper {
    public static final String PROVIDER = "BC";
    public static final String EXTENSION = "asc";
    private static final Language lang = new DefaultLanguage(PgpHelper.class);

    public static PGPSecretKeyRing readKeyRing(InputStream in, String hexId) throws IOException, PGPException {
        if (in == null) {
            throw new IllegalArgumentException(lang.getMessage("null.input.stream", new String[0]));
        }
        if (hexId == null || hexId.length() < 16) {
            throw new IllegalArgumentException(lang.getMessage("bad.key.id", new String[]{hexId}));
        }
        long id = PgpHelper.hexToId(hexId);
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(in);
        Iterator ringIt = pgpSec.getKeyRings();
        while (ringIt.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)ringIt.next();
            PGPSecretKey key = keyRing.getSecretKey(id);
            if (key == null) continue;
            return keyRing;
        }
        throw new IllegalArgumentException(lang.getMessage("no.secret.key", new String[]{hexId}));
    }

    public static long hexToId(String hexId) {
        BigInteger bi = new BigInteger(hexId, 16);
        return bi.longValue();
    }

    public static PGPSignature readSignature(InputStream inS) throws IOException, PGPException {
        if (inS == null) {
            throw new IllegalArgumentException("null.input.stream");
        }
        InputStream in = inS;
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(in);
        PGPSignatureList sigList = null;
        Object pgpObject = pgpObjectFactory.nextObject();
        if (pgpObject == null) {
            throw new PGPException(lang.getMessage("no.objects.in.stream", new String[0]));
        }
        if (pgpObject instanceof PGPCompressedData) {
            PGPCompressedData cd = (PGPCompressedData)pgpObject;
            pgpObjectFactory = new PGPObjectFactory(cd.getDataStream());
            sigList = (PGPSignatureList)pgpObjectFactory.nextObject();
        } else {
            sigList = (PGPSignatureList)pgpObject;
        }
        if (sigList.size() < 1) {
            throw new PGPException(lang.getMessage("no.signatures.in.stream", new String[0]));
        }
        PGPSignature sig = sigList.get(0);
        return sig;
    }

    public static String streamToString(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        int b = 0;
        while ((b = in.read()) != -1) {
            ba.write(b);
        }
        return ba.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(String fileName) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            String string = PgpHelper.streamToString(fis);
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

