/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.merge;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.xml.Dom;

public class MavenToolchainMerger {
    public PersistedToolchains merge(PersistedToolchains dominant, PersistedToolchains recessive, String recessiveSourceLevel) {
        if (dominant == null || recessive == null) {
            return dominant;
        }
        recessive.setSourceLevel(recessiveSourceLevel);
        return this.shallowMerge(dominant.getToolchains(), recessive.getToolchains(), recessiveSourceLevel);
    }

    private PersistedToolchains shallowMerge(List<ToolchainModel> dominant, List<ToolchainModel> recessive, String recessiveSourceLevel) {
        Object key;
        LinkedHashMap<Object, ToolchainModel> merged = new LinkedHashMap<Object, ToolchainModel>();
        for (ToolchainModel dominantModel : dominant) {
            key = this.getToolchainModelKey(dominantModel);
            merged.put(key, dominantModel);
        }
        for (ToolchainModel recessiveModel : recessive) {
            key = this.getToolchainModelKey(recessiveModel);
            ToolchainModel dominantModel = (ToolchainModel)merged.get(key);
            if (dominantModel == null) {
                recessiveModel.setSourceLevel(recessiveSourceLevel);
                merged.put(key, recessiveModel);
                continue;
            }
            merged.put(key, this.mergeToolchainModelConfiguration(dominantModel, recessiveModel));
        }
        return PersistedToolchains.newBuilder().toolchains(new ArrayList(merged.values())).build();
    }

    protected ToolchainModel mergeToolchainModelConfiguration(ToolchainModel target, ToolchainModel source) {
        Dom src = source.getConfiguration();
        Dom tgt = target.getConfiguration();
        Dom merged = Dom.merge((Dom)tgt, (Dom)src);
        return target.withConfiguration(merged);
    }

    protected Object getToolchainModelKey(ToolchainModel model) {
        return model;
    }
}

