/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         This is an activator which will detect an operating
 * system's attributes in order to activate
 *         its profile.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ActivationOS implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The name of the OS to be used to activate a
     * profile.
     *           
     */
    private String name;

    /**
     * 
     *             The general family of the OS to be used to
     * activate a
     *             profile (e.g. 'windows')
     *           .
     */
    private String family;

    /**
     * 
     *             The architecture of the OS to be used to
     * activate a profile.
     *           
     */
    private String arch;

    /**
     * 
     *             The version of the OS to be used to activate a
     * profile.
     *           
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The architecture of the OS to be used to
     * activate a profile.
     *           
     * 
     * @return String
     */
    public String getArch()
    {
        return this.arch;
    } //-- String getArch() 

    /**
     * Get 
     *             The general family of the OS to be used to
     * activate a
     *             profile (e.g. 'windows')
     *           .
     * 
     * @return String
     */
    public String getFamily()
    {
        return this.family;
    } //-- String getFamily() 

    /**
     * Get 
     *             The name of the OS to be used to activate a
     * profile.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *             The version of the OS to be used to activate a
     * profile.
     *           
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set 
     *             The architecture of the OS to be used to
     * activate a profile.
     *           
     * 
     * @param arch
     */
    public void setArch( String arch )
    {
        this.arch = arch;
    } //-- void setArch( String ) 

    /**
     * Set 
     *             The general family of the OS to be used to
     * activate a
     *             profile (e.g. 'windows')
     *           .
     * 
     * @param family
     */
    public void setFamily( String family )
    {
        this.family = family;
    } //-- void setFamily( String ) 

    /**
     * Set 
     *             The name of the OS to be used to activate a
     * profile.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String ) 

    /**
     * Set 
     *             The version of the OS to be used to activate a
     * profile.
     *           
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
