/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.builder.PomArtifactResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPomArtifactResolver
implements PomArtifactResolver {
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactResolver resolver;

    public DefaultPomArtifactResolver(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactResolver resolver) {
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.resolver = resolver;
    }

    @Override
    public void resolve(Artifact artifact) throws IOException {
        File artifactFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        artifact.setFile(artifactFile);
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}

