package org.apache.maven.project;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: ProjectBuildingException.java 312827 2005-10-11 07:35:33Z jdcasey $
 */
public class ProjectBuildingException
    extends Exception
{
    private final String projectId;

    public ProjectBuildingException( String projectId, String message )
    {
        super( message );
        this.projectId = projectId;
    }

    public ProjectBuildingException( String projectId, String message, Throwable cause )
    {
        super( message, cause );
        this.projectId = projectId;
    }
    
    public String getProjectId()
    {
        return projectId;
    }
}
