package org.apache.maven.project;


/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Exception that occurs when the project list contains duplicate projects instead of ignoring one.
 * 
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: DuplicateProjectException.java 327763 2005-10-23 08:07:38Z brett $
 */
public class DuplicateProjectException
    extends Exception
{
    public DuplicateProjectException( String message )
    {
        super( message );
    }
    
    public DuplicateProjectException( String message, Exception e )
    {
        super( message, e );
    }
}
