/*
 * $Id$
 */

package org.apache.maven.profiles;

/**
 * 
 *         This is the property specification used to activate a
 * profile. If the value field is empty, 
 *         then the existence of the named property will activate
 * the profile, otherwise it does a case-sensitive
 *         match against the property value as well.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class ActivationProperty implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field value
     */
    private String value;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The name of the property to be used to activate a profile
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get The value of the property to be used to activate a profil
     */
    public String getValue()
    {
        return this.value;
    } //-- String getValue() 

    /**
     * Set The name of the property to be used to activate a
     * profile
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set The value of the property to be used to activate a
     * profile
     * 
     * @param value
     */
    public void setValue(String value)
    {
        this.value = value;
    } //-- void setValue(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
