/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.descriptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.plugin.descriptor.lifecycle.Lifecycle;
import org.apache.maven.api.plugin.descriptor.lifecycle.LifecycleConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.DuplicateMojoDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.lifecycle.io.LifecycleStaxReader;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.eclipse.aether.graph.DependencyNode;

public class PluginDescriptor
extends ComponentSetDescriptor
implements Cloneable {
    private static final String LIFECYCLE_DESCRIPTOR = "META-INF/maven/lifecycle.xml";
    private static final Pattern PATTERN_FILTER_1 = Pattern.compile("-?(maven|plugin)-?");
    private String groupId;
    private String artifactId;
    private String version;
    private String goalPrefix;
    private String source;
    private boolean inheritedByDefault = true;
    private List<Artifact> artifacts;
    private DependencyNode dependencyNode;
    private ClassRealm classRealm;
    private Map<String, Artifact> artifactMap;
    private Set<Artifact> introducedDependencyArtifacts;
    private String name;
    private String description;
    private String requiredMavenVersion;
    private String requiredJavaVersion;
    private Plugin plugin;
    private Artifact pluginArtifact;
    private Map<String, Lifecycle> lifecycleMappings;
    private volatile org.apache.maven.api.plugin.descriptor.PluginDescriptor pluginDescriptorV4;

    public PluginDescriptor() {
    }

    public PluginDescriptor(PluginDescriptor original) {
        this.setGroupId(original.getGroupId());
        this.setArtifactId(original.getArtifactId());
        this.setVersion(original.getVersion());
        this.setGoalPrefix(original.getGoalPrefix());
        this.setInheritedByDefault(original.isInheritedByDefault());
        this.setName(original.getName());
        this.setDescription(original.getDescription());
        this.setRequiredMavenVersion(original.getRequiredMavenVersion());
        this.setRequiredJavaVersion(original.getRequiredJavaVersion());
        this.setPluginArtifact(ArtifactUtils.copyArtifactSafe((Artifact)original.getPluginArtifact()));
        this.setComponents(PluginDescriptor.clone(original.getMojos(), this));
        this.setId(original.getId());
        this.setIsolatedRealm(original.isIsolatedRealm());
        this.setSource(original.getSource());
        this.setDependencies(original.getDependencies());
        this.setDependencyNode(original.getDependencyNode());
    }

    private static List<ComponentDescriptor<?>> clone(List<MojoDescriptor> mojos, PluginDescriptor pluginDescriptor) {
        ArrayList<MojoDescriptor> clones = null;
        if (mojos != null) {
            clones = new ArrayList<MojoDescriptor>(mojos.size());
            for (MojoDescriptor mojo : mojos) {
                MojoDescriptor clone = mojo.clone();
                clone.setPluginDescriptor(pluginDescriptor);
                clones.add(clone);
            }
        }
        return clones;
    }

    public PluginDescriptor(org.apache.maven.api.plugin.descriptor.PluginDescriptor original) {
        this.setGroupId(original.getGroupId());
        this.setArtifactId(original.getArtifactId());
        this.setVersion(original.getVersion());
        this.setGoalPrefix(original.getGoalPrefix());
        this.setInheritedByDefault(original.isInheritedByDefault());
        this.setName(original.getName());
        this.setDescription(original.getDescription());
        this.setRequiredMavenVersion(original.getRequiredMavenVersion());
        this.setRequiredJavaVersion(original.getRequiredJavaVersion());
        this.setPluginArtifact(null);
        this.setComponents(original.getMojos().stream().map(m -> new MojoDescriptor(this, (org.apache.maven.api.plugin.descriptor.MojoDescriptor)m)).collect(Collectors.toList()));
        this.setId(original.getId());
        this.setIsolatedRealm(original.isIsolatedRealm());
        this.setSource(null);
        this.setDependencies(Collections.emptyList());
        this.setDependencyNode(null);
        this.pluginDescriptorV4 = original;
    }

    public List<MojoDescriptor> getMojos() {
        return this.getComponents();
    }

    public void addMojo(MojoDescriptor mojoDescriptor) throws DuplicateMojoDescriptorException {
        MojoDescriptor existing = null;
        List<MojoDescriptor> mojos = this.getMojos();
        if (mojos != null && mojos.contains(mojoDescriptor)) {
            int indexOf = mojos.indexOf(mojoDescriptor);
            existing = mojos.get(indexOf);
        }
        if (existing != null) {
            throw new DuplicateMojoDescriptorException(this.getGoalPrefix(), mojoDescriptor.getGoal(), existing.getImplementation(), mojoDescriptor.getImplementation());
        }
        this.addComponentDescriptor(mojoDescriptor);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public static String constructPluginKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public String getPluginLookupKey() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getId() {
        return PluginDescriptor.constructPluginKey(this.groupId, this.artifactId, this.version);
    }

    public static String getDefaultPluginArtifactId(String id) {
        return "maven-" + id + "-plugin";
    }

    public static String getDefaultPluginGroupId() {
        return "org.apache.maven.plugins";
    }

    public static String getGoalPrefixFromArtifactId(String artifactId) {
        if ("maven-plugin-plugin".equals(artifactId)) {
            return "plugin";
        }
        return PATTERN_FILTER_1.matcher(artifactId).replaceAll("");
    }

    public String getGoalPrefix() {
        return this.goalPrefix;
    }

    public void setGoalPrefix(String goalPrefix) {
        this.goalPrefix = goalPrefix;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public void setInheritedByDefault(boolean inheritedByDefault) {
        this.inheritedByDefault = inheritedByDefault;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        this.artifactMap = null;
    }

    public DependencyNode getDependencyNode() {
        return this.dependencyNode;
    }

    public void setDependencyNode(DependencyNode dependencyNode) {
        this.dependencyNode = dependencyNode;
    }

    public Map<String, Artifact> getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId(this.getArtifacts());
        }
        return this.artifactMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PluginDescriptor)) return false;
        PluginDescriptor pluginDescriptor = (PluginDescriptor)object;
        if (!this.getId().equals(pluginDescriptor.getId())) return false;
        return true;
    }

    public int hashCode() {
        return 10 + this.getId().hashCode();
    }

    public MojoDescriptor getMojo(String goal) {
        if (this.getMojos() == null) {
            return null;
        }
        for (MojoDescriptor desc : this.getMojos()) {
            if (!goal.equals(desc.getGoal())) continue;
            return desc;
        }
        return null;
    }

    public void setClassRealm(ClassRealm classRealm) {
        this.classRealm = classRealm;
    }

    public ClassRealm getClassRealm() {
        return this.classRealm;
    }

    public void setIntroducedDependencyArtifacts(Set<Artifact> introducedDependencyArtifacts) {
        this.introducedDependencyArtifacts = introducedDependencyArtifacts;
    }

    public Set<Artifact> getIntroducedDependencyArtifacts() {
        return this.introducedDependencyArtifacts != null ? this.introducedDependencyArtifacts : Collections.emptySet();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setRequiredMavenVersion(String requiredMavenVersion) {
        this.requiredMavenVersion = requiredMavenVersion;
    }

    public String getRequiredMavenVersion() {
        return this.requiredMavenVersion;
    }

    public void setRequiredJavaVersion(String requiredJavaVersion) {
        this.requiredJavaVersion = requiredJavaVersion;
    }

    public String getRequiredJavaVersion() {
        return this.requiredJavaVersion;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Artifact getPluginArtifact() {
        return this.pluginArtifact;
    }

    public void setPluginArtifact(Artifact pluginArtifact) {
        this.pluginArtifact = pluginArtifact;
    }

    public Lifecycle getLifecycleMapping(String lifecycleId) throws IOException, XMLStreamException {
        return this.getLifecycleMappings().get(lifecycleId);
    }

    public Map<String, Lifecycle> getLifecycleMappings() throws IOException, XMLStreamException {
        if (this.lifecycleMappings == null) {
            LifecycleConfiguration lifecycleConfiguration;
            try (InputStream input = this.getDescriptorStream(LIFECYCLE_DESCRIPTOR);){
                lifecycleConfiguration = new LifecycleStaxReader().read(input);
            }
            this.lifecycleMappings = new HashMap<String, Lifecycle>();
            for (Lifecycle lifecycle : lifecycleConfiguration.getLifecycles()) {
                this.lifecycleMappings.put(lifecycle.getId(), lifecycle);
            }
        }
        return this.lifecycleMappings;
    }

    private InputStream getDescriptorStream(String descriptor) throws IOException {
        File pluginFile;
        File file = pluginFile = this.pluginArtifact != null ? this.pluginArtifact.getFile() : null;
        if (pluginFile == null) {
            throw new IllegalStateException("plugin main artifact has not been resolved for " + this.getId());
        }
        if (pluginFile.isFile()) {
            try {
                return new URL("jar:" + pluginFile.toURI() + "!/" + descriptor).openStream();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return Files.newInputStream(new File(pluginFile, descriptor).toPath(), new OpenOption[0]);
    }

    public PluginDescriptor clone() {
        try {
            return (PluginDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public void addMojos(List<MojoDescriptor> mojos) throws DuplicateMojoDescriptorException {
        for (MojoDescriptor mojoDescriptor : mojos) {
            this.addMojo(mojoDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.maven.api.plugin.descriptor.PluginDescriptor getPluginDescriptorV4() {
        if (this.pluginDescriptorV4 == null) {
            PluginDescriptor pluginDescriptor = this;
            synchronized (pluginDescriptor) {
                if (this.pluginDescriptorV4 == null) {
                    this.pluginDescriptorV4 = org.apache.maven.api.plugin.descriptor.PluginDescriptor.newBuilder().namespaceUri(null).modelEncoding(null).name(this.name).description(this.description).groupId(this.groupId).artifactId(this.artifactId).version(this.version).goalPrefix(this.goalPrefix).isolatedRealm(this.isIsolatedRealm()).inheritedByDefault(this.inheritedByDefault).requiredJavaVersion(this.requiredJavaVersion).requiredMavenVersion(this.requiredMavenVersion).mojos((Collection)this.getMojos().stream().map(MojoDescriptor::getMojoDescriptorV4).collect(Collectors.toList())).build();
                }
            }
        }
        return this.pluginDescriptorV4;
    }
}

