/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.ImmutableCollections;

@Generated
@ThreadSafe
@Immutable
public class Phase
implements Serializable {
    final String id;
    final List<Execution> executions;
    final Dom configuration;

    Phase(String id, Collection<Execution> executions, Dom configuration) {
        this.id = id;
        this.executions = ImmutableCollections.copy(executions);
        this.configuration = configuration;
    }

    public String getId() {
        return this.id;
    }

    @Nonnull
    public List<Execution> getExecutions() {
        return this.executions;
    }

    public Dom getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Builder with() {
        return Phase.newBuilder(this);
    }

    @Nonnull
    public Phase withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public Phase withExecutions(Collection<Execution> executions) {
        return this.with().executions(executions).build();
    }

    @Nonnull
    public Phase withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public static Phase newInstance() {
        return Phase.newInstance(true);
    }

    @Nonnull
    public static Phase newInstance(boolean withDefaults) {
        return Phase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Phase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Phase from) {
        return Phase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Phase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Phase base;
        String id;
        Collection<Execution> executions;
        Dom configuration;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Phase base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.executions = base.executions;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<Execution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Phase build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.executions != null && this.executions != this.base.executions || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new Phase(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.executions != null ? this.executions : (this.base != null ? this.base.executions : null), (Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)));
        }
    }
}

