/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.v4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.Developer;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.License;
import org.apache.maven.api.model.MailingList;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Notifier;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.PatternSet;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.api.xml.Dom;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Generated
public class MavenTransformer {
    private final Function<String, String> transformer;

    public MavenTransformer(Function<String, String> transformer) {
        this.transformer = transformer;
    }

    public Model visit(Model target) {
        Objects.requireNonNull(target, "target cannot be null");
        return this.transformModel(target);
    }

    protected String transform(String value) {
        return this.transformer.apply(value);
    }

    protected Model transformModel(Model target) {
        if (target == null) {
            return null;
        }
        Model.Builder builder = Model.newBuilder((Model)target);
        this.transformModel_ModelVersion(builder, target);
        this.transformModel_Parent(builder, target);
        this.transformModel_GroupId(builder, target);
        this.transformModel_ArtifactId(builder, target);
        this.transformModel_Version(builder, target);
        this.transformModel_Packaging(builder, target);
        this.transformModel_Name(builder, target);
        this.transformModel_Description(builder, target);
        this.transformModel_Url(builder, target);
        this.transformModel_ChildProjectUrlInheritAppendPath(builder, target);
        this.transformModel_InceptionYear(builder, target);
        this.transformModel_Organization(builder, target);
        this.transformModel_Licenses(builder, target);
        this.transformModel_Developers(builder, target);
        this.transformModel_Contributors(builder, target);
        this.transformModel_MailingLists(builder, target);
        this.transformModel_Prerequisites(builder, target);
        this.transformModelBase_Modules((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModel_Scm(builder, target);
        this.transformModel_IssueManagement(builder, target);
        this.transformModel_CiManagement(builder, target);
        this.transformModelBase_DistributionManagement((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Properties((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_DependencyManagement((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Dependencies((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Repositories((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_PluginRepositories((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModel_Build(builder, target);
        this.transformModelBase_Reporting((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModel_Profiles(builder, target);
        return builder.build();
    }

    protected void transformModel_ModelVersion(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getModelVersion());
        builder.modelVersion(newVal != target.getModelVersion() ? newVal : null);
    }

    protected void transformModel_Parent(Model.Builder builder, Model target) {
        Parent newVal = this.transformParent(target.getParent());
        builder.parent((Parent)(newVal != target.getParent() ? newVal : null));
    }

    protected void transformModel_GroupId(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformModel_ArtifactId(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformModel_Version(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformModel_Packaging(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getPackaging());
        builder.packaging(newVal != target.getPackaging() ? newVal : null);
    }

    protected void transformModel_Name(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformModel_Description(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getDescription());
        builder.description(newVal != target.getDescription() ? newVal : null);
    }

    protected void transformModel_Url(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformModel_ChildProjectUrlInheritAppendPath(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getChildProjectUrlInheritAppendPath());
        builder.childProjectUrlInheritAppendPath(newVal != target.getChildProjectUrlInheritAppendPath() ? newVal : null);
    }

    protected void transformModel_InceptionYear(Model.Builder builder, Model target) {
        String newVal = this.transform(target.getInceptionYear());
        builder.inceptionYear(newVal != target.getInceptionYear() ? newVal : null);
    }

    protected void transformModel_Organization(Model.Builder builder, Model target) {
        Organization newVal = this.transformOrganization(target.getOrganization());
        builder.organization((Organization)(newVal != target.getOrganization() ? newVal : null));
    }

    protected void transformModel_Licenses(Model.Builder builder, Model target) {
        builder.licenses(this.transform(target.getLicenses(), this::transformLicense));
    }

    protected void transformModel_Developers(Model.Builder builder, Model target) {
        builder.developers(this.transform(target.getDevelopers(), this::transformDeveloper));
    }

    protected void transformModel_Contributors(Model.Builder builder, Model target) {
        builder.contributors(this.transform(target.getContributors(), this::transformContributor));
    }

    protected void transformModel_MailingLists(Model.Builder builder, Model target) {
        builder.mailingLists(this.transform(target.getMailingLists(), this::transformMailingList));
    }

    protected void transformModel_Prerequisites(Model.Builder builder, Model target) {
        Prerequisites newVal = this.transformPrerequisites(target.getPrerequisites());
        builder.prerequisites((Prerequisites)(newVal != target.getPrerequisites() ? newVal : null));
    }

    protected void transformModel_Modules(Model.Builder builder, Model target) {
        builder.modules(this.transform(target.getModules(), this::transform));
    }

    protected void transformModel_Scm(Model.Builder builder, Model target) {
        Scm newVal = this.transformScm(target.getScm());
        builder.scm((Scm)(newVal != target.getScm() ? newVal : null));
    }

    protected void transformModel_IssueManagement(Model.Builder builder, Model target) {
        IssueManagement newVal = this.transformIssueManagement(target.getIssueManagement());
        builder.issueManagement((IssueManagement)(newVal != target.getIssueManagement() ? newVal : null));
    }

    protected void transformModel_CiManagement(Model.Builder builder, Model target) {
        CiManagement newVal = this.transformCiManagement(target.getCiManagement());
        builder.ciManagement((CiManagement)(newVal != target.getCiManagement() ? newVal : null));
    }

    protected void transformModel_DistributionManagement(Model.Builder builder, Model target) {
        DistributionManagement newVal = this.transformDistributionManagement(target.getDistributionManagement());
        builder.distributionManagement((DistributionManagement)(newVal != target.getDistributionManagement() ? newVal : null));
    }

    protected void transformModel_Properties(Model.Builder builder, Model target) {
        Map props = target.getProperties();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected void transformModel_DependencyManagement(Model.Builder builder, Model target) {
        DependencyManagement newVal = this.transformDependencyManagement(target.getDependencyManagement());
        builder.dependencyManagement((DependencyManagement)(newVal != target.getDependencyManagement() ? newVal : null));
    }

    protected void transformModel_Dependencies(Model.Builder builder, Model target) {
        builder.dependencies(this.transform(target.getDependencies(), this::transformDependency));
    }

    protected void transformModel_Repositories(Model.Builder builder, Model target) {
        builder.repositories(this.transform(target.getRepositories(), this::transformRepository));
    }

    protected void transformModel_PluginRepositories(Model.Builder builder, Model target) {
        builder.pluginRepositories(this.transform(target.getPluginRepositories(), this::transformRepository));
    }

    protected void transformModel_Build(Model.Builder builder, Model target) {
        Build newVal = this.transformBuild(target.getBuild());
        builder.build((Build)(newVal != target.getBuild() ? newVal : null));
    }

    protected void transformModel_Reporting(Model.Builder builder, Model target) {
        Reporting newVal = this.transformReporting(target.getReporting());
        builder.reporting((Reporting)(newVal != target.getReporting() ? newVal : null));
    }

    protected void transformModel_Profiles(Model.Builder builder, Model target) {
        builder.profiles(this.transform(target.getProfiles(), this::transformProfile));
    }

    protected ModelBase transformModelBase(ModelBase target) {
        if (target == null) {
            return null;
        }
        ModelBase.Builder builder = ModelBase.newBuilder((ModelBase)target);
        this.transformModelBase_Modules(builder, target);
        this.transformModelBase_DistributionManagement(builder, target);
        this.transformModelBase_Properties(builder, target);
        this.transformModelBase_DependencyManagement(builder, target);
        this.transformModelBase_Dependencies(builder, target);
        this.transformModelBase_Repositories(builder, target);
        this.transformModelBase_PluginRepositories(builder, target);
        this.transformModelBase_Reporting(builder, target);
        return builder.build();
    }

    protected void transformModelBase_Modules(ModelBase.Builder builder, ModelBase target) {
        builder.modules(this.transform(target.getModules(), this::transform));
    }

    protected void transformModelBase_DistributionManagement(ModelBase.Builder builder, ModelBase target) {
        DistributionManagement newVal = this.transformDistributionManagement(target.getDistributionManagement());
        builder.distributionManagement((DistributionManagement)(newVal != target.getDistributionManagement() ? newVal : null));
    }

    protected void transformModelBase_Properties(ModelBase.Builder builder, ModelBase target) {
        Map props = target.getProperties();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected void transformModelBase_DependencyManagement(ModelBase.Builder builder, ModelBase target) {
        DependencyManagement newVal = this.transformDependencyManagement(target.getDependencyManagement());
        builder.dependencyManagement((DependencyManagement)(newVal != target.getDependencyManagement() ? newVal : null));
    }

    protected void transformModelBase_Dependencies(ModelBase.Builder builder, ModelBase target) {
        builder.dependencies(this.transform(target.getDependencies(), this::transformDependency));
    }

    protected void transformModelBase_Repositories(ModelBase.Builder builder, ModelBase target) {
        builder.repositories(this.transform(target.getRepositories(), this::transformRepository));
    }

    protected void transformModelBase_PluginRepositories(ModelBase.Builder builder, ModelBase target) {
        builder.pluginRepositories(this.transform(target.getPluginRepositories(), this::transformRepository));
    }

    protected void transformModelBase_Reporting(ModelBase.Builder builder, ModelBase target) {
        Reporting newVal = this.transformReporting(target.getReporting());
        builder.reporting((Reporting)(newVal != target.getReporting() ? newVal : null));
    }

    protected PluginContainer transformPluginContainer(PluginContainer target) {
        if (target == null) {
            return null;
        }
        PluginContainer.Builder builder = PluginContainer.newBuilder((PluginContainer)target);
        this.transformPluginContainer_Plugins(builder, target);
        return builder.build();
    }

    protected void transformPluginContainer_Plugins(PluginContainer.Builder builder, PluginContainer target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformPlugin));
    }

    protected PluginConfiguration transformPluginConfiguration(PluginConfiguration target) {
        if (target == null) {
            return null;
        }
        PluginConfiguration.Builder builder = PluginConfiguration.newBuilder((PluginConfiguration)target);
        this.transformPluginConfiguration_PluginManagement(builder, target);
        this.transformPluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)target);
        return builder.build();
    }

    protected void transformPluginConfiguration_PluginManagement(PluginConfiguration.Builder builder, PluginConfiguration target) {
        PluginManagement newVal = this.transformPluginManagement(target.getPluginManagement());
        builder.pluginManagement((PluginManagement)(newVal != target.getPluginManagement() ? newVal : null));
    }

    protected void transformPluginConfiguration_Plugins(PluginConfiguration.Builder builder, PluginConfiguration target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformPlugin));
    }

    protected BuildBase transformBuildBase(BuildBase target) {
        if (target == null) {
            return null;
        }
        BuildBase.Builder builder = BuildBase.newBuilder((BuildBase)target);
        this.transformBuildBase_DefaultGoal(builder, target);
        this.transformBuildBase_Resources(builder, target);
        this.transformBuildBase_TestResources(builder, target);
        this.transformBuildBase_Directory(builder, target);
        this.transformBuildBase_FinalName(builder, target);
        this.transformBuildBase_Filters(builder, target);
        this.transformPluginConfiguration_PluginManagement((PluginConfiguration.Builder)builder, (PluginConfiguration)target);
        this.transformPluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)target);
        return builder.build();
    }

    protected void transformBuildBase_DefaultGoal(BuildBase.Builder builder, BuildBase target) {
        String newVal = this.transform(target.getDefaultGoal());
        builder.defaultGoal(newVal != target.getDefaultGoal() ? newVal : null);
    }

    protected void transformBuildBase_Resources(BuildBase.Builder builder, BuildBase target) {
        builder.resources(this.transform(target.getResources(), this::transformResource));
    }

    protected void transformBuildBase_TestResources(BuildBase.Builder builder, BuildBase target) {
        builder.testResources(this.transform(target.getTestResources(), this::transformResource));
    }

    protected void transformBuildBase_Directory(BuildBase.Builder builder, BuildBase target) {
        String newVal = this.transform(target.getDirectory());
        builder.directory(newVal != target.getDirectory() ? newVal : null);
    }

    protected void transformBuildBase_FinalName(BuildBase.Builder builder, BuildBase target) {
        String newVal = this.transform(target.getFinalName());
        builder.finalName(newVal != target.getFinalName() ? newVal : null);
    }

    protected void transformBuildBase_Filters(BuildBase.Builder builder, BuildBase target) {
        builder.filters(this.transform(target.getFilters(), this::transform));
    }

    protected void transformBuildBase_PluginManagement(BuildBase.Builder builder, BuildBase target) {
        PluginManagement newVal = this.transformPluginManagement(target.getPluginManagement());
        builder.pluginManagement((PluginManagement)(newVal != target.getPluginManagement() ? newVal : null));
    }

    protected void transformBuildBase_Plugins(BuildBase.Builder builder, BuildBase target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformPlugin));
    }

    protected Build transformBuild(Build target) {
        if (target == null) {
            return null;
        }
        Build.Builder builder = Build.newBuilder((Build)target);
        this.transformBuild_SourceDirectory(builder, target);
        this.transformBuild_ScriptSourceDirectory(builder, target);
        this.transformBuild_TestSourceDirectory(builder, target);
        this.transformBuild_OutputDirectory(builder, target);
        this.transformBuild_TestOutputDirectory(builder, target);
        this.transformBuild_Extensions(builder, target);
        this.transformBuildBase_DefaultGoal((BuildBase.Builder)builder, (BuildBase)target);
        this.transformBuildBase_Resources((BuildBase.Builder)builder, (BuildBase)target);
        this.transformBuildBase_TestResources((BuildBase.Builder)builder, (BuildBase)target);
        this.transformBuildBase_Directory((BuildBase.Builder)builder, (BuildBase)target);
        this.transformBuildBase_FinalName((BuildBase.Builder)builder, (BuildBase)target);
        this.transformBuildBase_Filters((BuildBase.Builder)builder, (BuildBase)target);
        this.transformPluginConfiguration_PluginManagement((PluginConfiguration.Builder)builder, (PluginConfiguration)target);
        this.transformPluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)target);
        return builder.build();
    }

    protected void transformBuild_SourceDirectory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getSourceDirectory());
        builder.sourceDirectory(newVal != target.getSourceDirectory() ? newVal : null);
    }

    protected void transformBuild_ScriptSourceDirectory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getScriptSourceDirectory());
        builder.scriptSourceDirectory(newVal != target.getScriptSourceDirectory() ? newVal : null);
    }

    protected void transformBuild_TestSourceDirectory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getTestSourceDirectory());
        builder.testSourceDirectory(newVal != target.getTestSourceDirectory() ? newVal : null);
    }

    protected void transformBuild_OutputDirectory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getOutputDirectory());
        builder.outputDirectory(newVal != target.getOutputDirectory() ? newVal : null);
    }

    protected void transformBuild_TestOutputDirectory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getTestOutputDirectory());
        builder.testOutputDirectory(newVal != target.getTestOutputDirectory() ? newVal : null);
    }

    protected void transformBuild_Extensions(Build.Builder builder, Build target) {
        builder.extensions(this.transform(target.getExtensions(), this::transformExtension));
    }

    protected void transformBuild_DefaultGoal(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getDefaultGoal());
        builder.defaultGoal(newVal != target.getDefaultGoal() ? newVal : null);
    }

    protected void transformBuild_Resources(Build.Builder builder, Build target) {
        builder.resources(this.transform(target.getResources(), this::transformResource));
    }

    protected void transformBuild_TestResources(Build.Builder builder, Build target) {
        builder.testResources(this.transform(target.getTestResources(), this::transformResource));
    }

    protected void transformBuild_Directory(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getDirectory());
        builder.directory(newVal != target.getDirectory() ? newVal : null);
    }

    protected void transformBuild_FinalName(Build.Builder builder, Build target) {
        String newVal = this.transform(target.getFinalName());
        builder.finalName(newVal != target.getFinalName() ? newVal : null);
    }

    protected void transformBuild_Filters(Build.Builder builder, Build target) {
        builder.filters(this.transform(target.getFilters(), this::transform));
    }

    protected void transformBuild_PluginManagement(Build.Builder builder, Build target) {
        PluginManagement newVal = this.transformPluginManagement(target.getPluginManagement());
        builder.pluginManagement((PluginManagement)(newVal != target.getPluginManagement() ? newVal : null));
    }

    protected void transformBuild_Plugins(Build.Builder builder, Build target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformPlugin));
    }

    protected CiManagement transformCiManagement(CiManagement target) {
        if (target == null) {
            return null;
        }
        CiManagement.Builder builder = CiManagement.newBuilder((CiManagement)target);
        this.transformCiManagement_System(builder, target);
        this.transformCiManagement_Url(builder, target);
        this.transformCiManagement_Notifiers(builder, target);
        return builder.build();
    }

    protected void transformCiManagement_System(CiManagement.Builder builder, CiManagement target) {
        String newVal = this.transform(target.getSystem());
        builder.system(newVal != target.getSystem() ? newVal : null);
    }

    protected void transformCiManagement_Url(CiManagement.Builder builder, CiManagement target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformCiManagement_Notifiers(CiManagement.Builder builder, CiManagement target) {
        builder.notifiers(this.transform(target.getNotifiers(), this::transformNotifier));
    }

    protected Notifier transformNotifier(Notifier target) {
        if (target == null) {
            return null;
        }
        Notifier.Builder builder = Notifier.newBuilder((Notifier)target);
        this.transformNotifier_Type(builder, target);
        this.transformNotifier_SendOnError(builder, target);
        this.transformNotifier_SendOnFailure(builder, target);
        this.transformNotifier_SendOnSuccess(builder, target);
        this.transformNotifier_SendOnWarning(builder, target);
        this.transformNotifier_Address(builder, target);
        this.transformNotifier_Configuration(builder, target);
        return builder.build();
    }

    protected void transformNotifier_Type(Notifier.Builder builder, Notifier target) {
        String newVal = this.transform(target.getType());
        builder.type(newVal != target.getType() ? newVal : null);
    }

    protected void transformNotifier_SendOnError(Notifier.Builder builder, Notifier target) {
    }

    protected void transformNotifier_SendOnFailure(Notifier.Builder builder, Notifier target) {
    }

    protected void transformNotifier_SendOnSuccess(Notifier.Builder builder, Notifier target) {
    }

    protected void transformNotifier_SendOnWarning(Notifier.Builder builder, Notifier target) {
    }

    protected void transformNotifier_Address(Notifier.Builder builder, Notifier target) {
        String newVal = this.transform(target.getAddress());
        builder.address(newVal != target.getAddress() ? newVal : null);
    }

    protected void transformNotifier_Configuration(Notifier.Builder builder, Notifier target) {
        Map props = target.getConfiguration();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.configuration(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected Contributor transformContributor(Contributor target) {
        if (target == null) {
            return null;
        }
        Contributor.Builder builder = Contributor.newBuilder((Contributor)target);
        this.transformContributor_Name(builder, target);
        this.transformContributor_Email(builder, target);
        this.transformContributor_Url(builder, target);
        this.transformContributor_Organization(builder, target);
        this.transformContributor_OrganizationUrl(builder, target);
        this.transformContributor_Roles(builder, target);
        this.transformContributor_Timezone(builder, target);
        this.transformContributor_Properties(builder, target);
        return builder.build();
    }

    protected void transformContributor_Name(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformContributor_Email(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getEmail());
        builder.email(newVal != target.getEmail() ? newVal : null);
    }

    protected void transformContributor_Url(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformContributor_Organization(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getOrganization());
        builder.organization(newVal != target.getOrganization() ? newVal : null);
    }

    protected void transformContributor_OrganizationUrl(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getOrganizationUrl());
        builder.organizationUrl(newVal != target.getOrganizationUrl() ? newVal : null);
    }

    protected void transformContributor_Roles(Contributor.Builder builder, Contributor target) {
        builder.roles(this.transform(target.getRoles(), this::transform));
    }

    protected void transformContributor_Timezone(Contributor.Builder builder, Contributor target) {
        String newVal = this.transform(target.getTimezone());
        builder.timezone(newVal != target.getTimezone() ? newVal : null);
    }

    protected void transformContributor_Properties(Contributor.Builder builder, Contributor target) {
        Map props = target.getProperties();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected Dependency transformDependency(Dependency target) {
        if (target == null) {
            return null;
        }
        Dependency.Builder builder = Dependency.newBuilder((Dependency)target);
        this.transformDependency_GroupId(builder, target);
        this.transformDependency_ArtifactId(builder, target);
        this.transformDependency_Version(builder, target);
        this.transformDependency_Type(builder, target);
        this.transformDependency_Classifier(builder, target);
        this.transformDependency_Scope(builder, target);
        this.transformDependency_SystemPath(builder, target);
        this.transformDependency_Exclusions(builder, target);
        this.transformDependency_Optional(builder, target);
        return builder.build();
    }

    protected void transformDependency_GroupId(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformDependency_ArtifactId(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformDependency_Version(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformDependency_Type(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getType());
        builder.type(newVal != target.getType() ? newVal : null);
    }

    protected void transformDependency_Classifier(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getClassifier());
        builder.classifier(newVal != target.getClassifier() ? newVal : null);
    }

    protected void transformDependency_Scope(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getScope());
        builder.scope(newVal != target.getScope() ? newVal : null);
    }

    protected void transformDependency_SystemPath(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getSystemPath());
        builder.systemPath(newVal != target.getSystemPath() ? newVal : null);
    }

    protected void transformDependency_Exclusions(Dependency.Builder builder, Dependency target) {
        builder.exclusions(this.transform(target.getExclusions(), this::transformExclusion));
    }

    protected void transformDependency_Optional(Dependency.Builder builder, Dependency target) {
        String newVal = this.transform(target.getOptional());
        builder.optional(newVal != target.getOptional() ? newVal : null);
    }

    protected Developer transformDeveloper(Developer target) {
        if (target == null) {
            return null;
        }
        Developer.Builder builder = Developer.newBuilder((Developer)target);
        this.transformDeveloper_Id(builder, target);
        this.transformContributor_Name((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Email((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Url((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Organization((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_OrganizationUrl((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Roles((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Timezone((Contributor.Builder)builder, (Contributor)target);
        this.transformContributor_Properties((Contributor.Builder)builder, (Contributor)target);
        return builder.build();
    }

    protected void transformDeveloper_Id(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformDeveloper_Name(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformDeveloper_Email(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getEmail());
        builder.email(newVal != target.getEmail() ? newVal : null);
    }

    protected void transformDeveloper_Url(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformDeveloper_Organization(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getOrganization());
        builder.organization(newVal != target.getOrganization() ? newVal : null);
    }

    protected void transformDeveloper_OrganizationUrl(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getOrganizationUrl());
        builder.organizationUrl(newVal != target.getOrganizationUrl() ? newVal : null);
    }

    protected void transformDeveloper_Roles(Developer.Builder builder, Developer target) {
        builder.roles(this.transform(target.getRoles(), this::transform));
    }

    protected void transformDeveloper_Timezone(Developer.Builder builder, Developer target) {
        String newVal = this.transform(target.getTimezone());
        builder.timezone(newVal != target.getTimezone() ? newVal : null);
    }

    protected void transformDeveloper_Properties(Developer.Builder builder, Developer target) {
        Map props = target.getProperties();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected Exclusion transformExclusion(Exclusion target) {
        if (target == null) {
            return null;
        }
        Exclusion.Builder builder = Exclusion.newBuilder((Exclusion)target);
        this.transformExclusion_GroupId(builder, target);
        this.transformExclusion_ArtifactId(builder, target);
        return builder.build();
    }

    protected void transformExclusion_GroupId(Exclusion.Builder builder, Exclusion target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformExclusion_ArtifactId(Exclusion.Builder builder, Exclusion target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected IssueManagement transformIssueManagement(IssueManagement target) {
        if (target == null) {
            return null;
        }
        IssueManagement.Builder builder = IssueManagement.newBuilder((IssueManagement)target);
        this.transformIssueManagement_System(builder, target);
        this.transformIssueManagement_Url(builder, target);
        return builder.build();
    }

    protected void transformIssueManagement_System(IssueManagement.Builder builder, IssueManagement target) {
        String newVal = this.transform(target.getSystem());
        builder.system(newVal != target.getSystem() ? newVal : null);
    }

    protected void transformIssueManagement_Url(IssueManagement.Builder builder, IssueManagement target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected DistributionManagement transformDistributionManagement(DistributionManagement target) {
        if (target == null) {
            return null;
        }
        DistributionManagement.Builder builder = DistributionManagement.newBuilder((DistributionManagement)target);
        this.transformDistributionManagement_Repository(builder, target);
        this.transformDistributionManagement_SnapshotRepository(builder, target);
        this.transformDistributionManagement_Site(builder, target);
        this.transformDistributionManagement_DownloadUrl(builder, target);
        this.transformDistributionManagement_Relocation(builder, target);
        this.transformDistributionManagement_Status(builder, target);
        return builder.build();
    }

    protected void transformDistributionManagement_Repository(DistributionManagement.Builder builder, DistributionManagement target) {
        DeploymentRepository newVal = this.transformDeploymentRepository(target.getRepository());
        builder.repository((DeploymentRepository)(newVal != target.getRepository() ? newVal : null));
    }

    protected void transformDistributionManagement_SnapshotRepository(DistributionManagement.Builder builder, DistributionManagement target) {
        DeploymentRepository newVal = this.transformDeploymentRepository(target.getSnapshotRepository());
        builder.snapshotRepository((DeploymentRepository)(newVal != target.getSnapshotRepository() ? newVal : null));
    }

    protected void transformDistributionManagement_Site(DistributionManagement.Builder builder, DistributionManagement target) {
        Site newVal = this.transformSite(target.getSite());
        builder.site((Site)(newVal != target.getSite() ? newVal : null));
    }

    protected void transformDistributionManagement_DownloadUrl(DistributionManagement.Builder builder, DistributionManagement target) {
        String newVal = this.transform(target.getDownloadUrl());
        builder.downloadUrl(newVal != target.getDownloadUrl() ? newVal : null);
    }

    protected void transformDistributionManagement_Relocation(DistributionManagement.Builder builder, DistributionManagement target) {
        Relocation newVal = this.transformRelocation(target.getRelocation());
        builder.relocation((Relocation)(newVal != target.getRelocation() ? newVal : null));
    }

    protected void transformDistributionManagement_Status(DistributionManagement.Builder builder, DistributionManagement target) {
        String newVal = this.transform(target.getStatus());
        builder.status(newVal != target.getStatus() ? newVal : null);
    }

    protected License transformLicense(License target) {
        if (target == null) {
            return null;
        }
        License.Builder builder = License.newBuilder((License)target);
        this.transformLicense_Name(builder, target);
        this.transformLicense_Url(builder, target);
        this.transformLicense_Distribution(builder, target);
        this.transformLicense_Comments(builder, target);
        return builder.build();
    }

    protected void transformLicense_Name(License.Builder builder, License target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformLicense_Url(License.Builder builder, License target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformLicense_Distribution(License.Builder builder, License target) {
        String newVal = this.transform(target.getDistribution());
        builder.distribution(newVal != target.getDistribution() ? newVal : null);
    }

    protected void transformLicense_Comments(License.Builder builder, License target) {
        String newVal = this.transform(target.getComments());
        builder.comments(newVal != target.getComments() ? newVal : null);
    }

    protected MailingList transformMailingList(MailingList target) {
        if (target == null) {
            return null;
        }
        MailingList.Builder builder = MailingList.newBuilder((MailingList)target);
        this.transformMailingList_Name(builder, target);
        this.transformMailingList_Subscribe(builder, target);
        this.transformMailingList_Unsubscribe(builder, target);
        this.transformMailingList_Post(builder, target);
        this.transformMailingList_Archive(builder, target);
        this.transformMailingList_OtherArchives(builder, target);
        return builder.build();
    }

    protected void transformMailingList_Name(MailingList.Builder builder, MailingList target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformMailingList_Subscribe(MailingList.Builder builder, MailingList target) {
        String newVal = this.transform(target.getSubscribe());
        builder.subscribe(newVal != target.getSubscribe() ? newVal : null);
    }

    protected void transformMailingList_Unsubscribe(MailingList.Builder builder, MailingList target) {
        String newVal = this.transform(target.getUnsubscribe());
        builder.unsubscribe(newVal != target.getUnsubscribe() ? newVal : null);
    }

    protected void transformMailingList_Post(MailingList.Builder builder, MailingList target) {
        String newVal = this.transform(target.getPost());
        builder.post(newVal != target.getPost() ? newVal : null);
    }

    protected void transformMailingList_Archive(MailingList.Builder builder, MailingList target) {
        String newVal = this.transform(target.getArchive());
        builder.archive(newVal != target.getArchive() ? newVal : null);
    }

    protected void transformMailingList_OtherArchives(MailingList.Builder builder, MailingList target) {
        builder.otherArchives(this.transform(target.getOtherArchives(), this::transform));
    }

    protected Organization transformOrganization(Organization target) {
        if (target == null) {
            return null;
        }
        Organization.Builder builder = Organization.newBuilder((Organization)target);
        this.transformOrganization_Name(builder, target);
        this.transformOrganization_Url(builder, target);
        return builder.build();
    }

    protected void transformOrganization_Name(Organization.Builder builder, Organization target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformOrganization_Url(Organization.Builder builder, Organization target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected PatternSet transformPatternSet(PatternSet target) {
        if (target == null) {
            return null;
        }
        PatternSet.Builder builder = PatternSet.newBuilder((PatternSet)target);
        this.transformPatternSet_Includes(builder, target);
        this.transformPatternSet_Excludes(builder, target);
        return builder.build();
    }

    protected void transformPatternSet_Includes(PatternSet.Builder builder, PatternSet target) {
        builder.includes(this.transform(target.getIncludes(), this::transform));
    }

    protected void transformPatternSet_Excludes(PatternSet.Builder builder, PatternSet target) {
        builder.excludes(this.transform(target.getExcludes(), this::transform));
    }

    protected Parent transformParent(Parent target) {
        if (target == null) {
            return null;
        }
        Parent.Builder builder = Parent.newBuilder((Parent)target);
        this.transformParent_GroupId(builder, target);
        this.transformParent_ArtifactId(builder, target);
        this.transformParent_Version(builder, target);
        this.transformParent_RelativePath(builder, target);
        return builder.build();
    }

    protected void transformParent_GroupId(Parent.Builder builder, Parent target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformParent_ArtifactId(Parent.Builder builder, Parent target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformParent_Version(Parent.Builder builder, Parent target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformParent_RelativePath(Parent.Builder builder, Parent target) {
        String newVal = this.transform(target.getRelativePath());
        builder.relativePath(newVal != target.getRelativePath() ? newVal : null);
    }

    protected Scm transformScm(Scm target) {
        if (target == null) {
            return null;
        }
        Scm.Builder builder = Scm.newBuilder((Scm)target);
        this.transformScm_Connection(builder, target);
        this.transformScm_DeveloperConnection(builder, target);
        this.transformScm_Tag(builder, target);
        this.transformScm_Url(builder, target);
        this.transformScm_ChildScmConnectionInheritAppendPath(builder, target);
        this.transformScm_ChildScmDeveloperConnectionInheritAppendPath(builder, target);
        this.transformScm_ChildScmUrlInheritAppendPath(builder, target);
        return builder.build();
    }

    protected void transformScm_Connection(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getConnection());
        builder.connection(newVal != target.getConnection() ? newVal : null);
    }

    protected void transformScm_DeveloperConnection(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getDeveloperConnection());
        builder.developerConnection(newVal != target.getDeveloperConnection() ? newVal : null);
    }

    protected void transformScm_Tag(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getTag());
        builder.tag(newVal != target.getTag() ? newVal : null);
    }

    protected void transformScm_Url(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformScm_ChildScmConnectionInheritAppendPath(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getChildScmConnectionInheritAppendPath());
        builder.childScmConnectionInheritAppendPath(newVal != target.getChildScmConnectionInheritAppendPath() ? newVal : null);
    }

    protected void transformScm_ChildScmDeveloperConnectionInheritAppendPath(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getChildScmDeveloperConnectionInheritAppendPath());
        builder.childScmDeveloperConnectionInheritAppendPath(newVal != target.getChildScmDeveloperConnectionInheritAppendPath() ? newVal : null);
    }

    protected void transformScm_ChildScmUrlInheritAppendPath(Scm.Builder builder, Scm target) {
        String newVal = this.transform(target.getChildScmUrlInheritAppendPath());
        builder.childScmUrlInheritAppendPath(newVal != target.getChildScmUrlInheritAppendPath() ? newVal : null);
    }

    protected FileSet transformFileSet(FileSet target) {
        if (target == null) {
            return null;
        }
        FileSet.Builder builder = FileSet.newBuilder((FileSet)target);
        this.transformFileSet_Directory(builder, target);
        this.transformPatternSet_Includes((PatternSet.Builder)builder, (PatternSet)target);
        this.transformPatternSet_Excludes((PatternSet.Builder)builder, (PatternSet)target);
        return builder.build();
    }

    protected void transformFileSet_Directory(FileSet.Builder builder, FileSet target) {
        String newVal = this.transform(target.getDirectory());
        builder.directory(newVal != target.getDirectory() ? newVal : null);
    }

    protected void transformFileSet_Includes(FileSet.Builder builder, FileSet target) {
        builder.includes(this.transform(target.getIncludes(), this::transform));
    }

    protected void transformFileSet_Excludes(FileSet.Builder builder, FileSet target) {
        builder.excludes(this.transform(target.getExcludes(), this::transform));
    }

    protected Resource transformResource(Resource target) {
        if (target == null) {
            return null;
        }
        Resource.Builder builder = Resource.newBuilder((Resource)target);
        this.transformResource_TargetPath(builder, target);
        this.transformResource_Filtering(builder, target);
        this.transformFileSet_Directory((FileSet.Builder)builder, (FileSet)target);
        this.transformPatternSet_Includes((PatternSet.Builder)builder, (PatternSet)target);
        this.transformPatternSet_Excludes((PatternSet.Builder)builder, (PatternSet)target);
        return builder.build();
    }

    protected void transformResource_TargetPath(Resource.Builder builder, Resource target) {
        String newVal = this.transform(target.getTargetPath());
        builder.targetPath(newVal != target.getTargetPath() ? newVal : null);
    }

    protected void transformResource_Filtering(Resource.Builder builder, Resource target) {
        String newVal = this.transform(target.getFiltering());
        builder.filtering(newVal != target.getFiltering() ? newVal : null);
    }

    protected void transformResource_Directory(Resource.Builder builder, Resource target) {
        String newVal = this.transform(target.getDirectory());
        builder.directory(newVal != target.getDirectory() ? newVal : null);
    }

    protected void transformResource_Includes(Resource.Builder builder, Resource target) {
        builder.includes(this.transform(target.getIncludes(), this::transform));
    }

    protected void transformResource_Excludes(Resource.Builder builder, Resource target) {
        builder.excludes(this.transform(target.getExcludes(), this::transform));
    }

    protected RepositoryBase transformRepositoryBase(RepositoryBase target) {
        if (target == null) {
            return null;
        }
        RepositoryBase.Builder builder = RepositoryBase.newBuilder((RepositoryBase)target);
        this.transformRepositoryBase_Id(builder, target);
        this.transformRepositoryBase_Name(builder, target);
        this.transformRepositoryBase_Url(builder, target);
        this.transformRepositoryBase_Layout(builder, target);
        return builder.build();
    }

    protected void transformRepositoryBase_Id(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformRepositoryBase_Name(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformRepositoryBase_Url(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformRepositoryBase_Layout(RepositoryBase.Builder builder, RepositoryBase target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected Repository transformRepository(Repository target) {
        if (target == null) {
            return null;
        }
        Repository.Builder builder = Repository.newBuilder((Repository)target);
        this.transformRepository_Releases(builder, target);
        this.transformRepository_Snapshots(builder, target);
        this.transformRepositoryBase_Id((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Name((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Url((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Layout((RepositoryBase.Builder)builder, (RepositoryBase)target);
        return builder.build();
    }

    protected void transformRepository_Releases(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getReleases());
        builder.releases((RepositoryPolicy)(newVal != target.getReleases() ? newVal : null));
    }

    protected void transformRepository_Snapshots(Repository.Builder builder, Repository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getSnapshots());
        builder.snapshots((RepositoryPolicy)(newVal != target.getSnapshots() ? newVal : null));
    }

    protected void transformRepository_Id(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformRepository_Name(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformRepository_Url(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformRepository_Layout(Repository.Builder builder, Repository target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected DeploymentRepository transformDeploymentRepository(DeploymentRepository target) {
        if (target == null) {
            return null;
        }
        DeploymentRepository.Builder builder = DeploymentRepository.newBuilder((DeploymentRepository)target);
        this.transformDeploymentRepository_UniqueVersion(builder, target);
        this.transformRepository_Releases((Repository.Builder)builder, (Repository)target);
        this.transformRepository_Snapshots((Repository.Builder)builder, (Repository)target);
        this.transformRepositoryBase_Id((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Name((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Url((RepositoryBase.Builder)builder, (RepositoryBase)target);
        this.transformRepositoryBase_Layout((RepositoryBase.Builder)builder, (RepositoryBase)target);
        return builder.build();
    }

    protected void transformDeploymentRepository_UniqueVersion(DeploymentRepository.Builder builder, DeploymentRepository target) {
    }

    protected void transformDeploymentRepository_Releases(DeploymentRepository.Builder builder, DeploymentRepository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getReleases());
        builder.releases((RepositoryPolicy)(newVal != target.getReleases() ? newVal : null));
    }

    protected void transformDeploymentRepository_Snapshots(DeploymentRepository.Builder builder, DeploymentRepository target) {
        RepositoryPolicy newVal = this.transformRepositoryPolicy(target.getSnapshots());
        builder.snapshots((RepositoryPolicy)(newVal != target.getSnapshots() ? newVal : null));
    }

    protected void transformDeploymentRepository_Id(DeploymentRepository.Builder builder, DeploymentRepository target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformDeploymentRepository_Name(DeploymentRepository.Builder builder, DeploymentRepository target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformDeploymentRepository_Url(DeploymentRepository.Builder builder, DeploymentRepository target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformDeploymentRepository_Layout(DeploymentRepository.Builder builder, DeploymentRepository target) {
        String newVal = this.transform(target.getLayout());
        builder.layout(newVal != target.getLayout() ? newVal : null);
    }

    protected RepositoryPolicy transformRepositoryPolicy(RepositoryPolicy target) {
        if (target == null) {
            return null;
        }
        RepositoryPolicy.Builder builder = RepositoryPolicy.newBuilder((RepositoryPolicy)target);
        this.transformRepositoryPolicy_Enabled(builder, target);
        this.transformRepositoryPolicy_UpdatePolicy(builder, target);
        this.transformRepositoryPolicy_ChecksumPolicy(builder, target);
        return builder.build();
    }

    protected void transformRepositoryPolicy_Enabled(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = this.transform(target.getEnabled());
        builder.enabled(newVal != target.getEnabled() ? newVal : null);
    }

    protected void transformRepositoryPolicy_UpdatePolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = this.transform(target.getUpdatePolicy());
        builder.updatePolicy(newVal != target.getUpdatePolicy() ? newVal : null);
    }

    protected void transformRepositoryPolicy_ChecksumPolicy(RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String newVal = this.transform(target.getChecksumPolicy());
        builder.checksumPolicy(newVal != target.getChecksumPolicy() ? newVal : null);
    }

    protected Site transformSite(Site target) {
        if (target == null) {
            return null;
        }
        Site.Builder builder = Site.newBuilder((Site)target);
        this.transformSite_Id(builder, target);
        this.transformSite_Name(builder, target);
        this.transformSite_Url(builder, target);
        this.transformSite_ChildSiteUrlInheritAppendPath(builder, target);
        return builder.build();
    }

    protected void transformSite_Id(Site.Builder builder, Site target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformSite_Name(Site.Builder builder, Site target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformSite_Url(Site.Builder builder, Site target) {
        String newVal = this.transform(target.getUrl());
        builder.url(newVal != target.getUrl() ? newVal : null);
    }

    protected void transformSite_ChildSiteUrlInheritAppendPath(Site.Builder builder, Site target) {
        String newVal = this.transform(target.getChildSiteUrlInheritAppendPath());
        builder.childSiteUrlInheritAppendPath(newVal != target.getChildSiteUrlInheritAppendPath() ? newVal : null);
    }

    protected ConfigurationContainer transformConfigurationContainer(ConfigurationContainer target) {
        if (target == null) {
            return null;
        }
        ConfigurationContainer.Builder builder = ConfigurationContainer.newBuilder((ConfigurationContainer)target);
        this.transformConfigurationContainer_Inherited(builder, target);
        this.transformConfigurationContainer_Configuration(builder, target);
        return builder.build();
    }

    protected void transformConfigurationContainer_Inherited(ConfigurationContainer.Builder builder, ConfigurationContainer target) {
        String newVal = this.transform(target.getInherited());
        builder.inherited(newVal != target.getInherited() ? newVal : null);
    }

    protected void transformConfigurationContainer_Configuration(ConfigurationContainer.Builder builder, ConfigurationContainer target) {
        Dom newVal = this.transform(target.getConfiguration());
        builder.configuration((Dom)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected Plugin transformPlugin(Plugin target) {
        if (target == null) {
            return null;
        }
        Plugin.Builder builder = Plugin.newBuilder((Plugin)target);
        this.transformPlugin_GroupId(builder, target);
        this.transformPlugin_ArtifactId(builder, target);
        this.transformPlugin_Version(builder, target);
        this.transformPlugin_Extensions(builder, target);
        this.transformPlugin_Executions(builder, target);
        this.transformPlugin_Dependencies(builder, target);
        this.transformConfigurationContainer_Inherited((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        this.transformConfigurationContainer_Configuration((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        return builder.build();
    }

    protected void transformPlugin_GroupId(Plugin.Builder builder, Plugin target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformPlugin_ArtifactId(Plugin.Builder builder, Plugin target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformPlugin_Version(Plugin.Builder builder, Plugin target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformPlugin_Extensions(Plugin.Builder builder, Plugin target) {
        String newVal = this.transform(target.getExtensions());
        builder.extensions(newVal != target.getExtensions() ? newVal : null);
    }

    protected void transformPlugin_Executions(Plugin.Builder builder, Plugin target) {
        builder.executions(this.transform(target.getExecutions(), this::transformPluginExecution));
    }

    protected void transformPlugin_Dependencies(Plugin.Builder builder, Plugin target) {
        builder.dependencies(this.transform(target.getDependencies(), this::transformDependency));
    }

    protected void transformPlugin_Inherited(Plugin.Builder builder, Plugin target) {
        String newVal = this.transform(target.getInherited());
        builder.inherited(newVal != target.getInherited() ? newVal : null);
    }

    protected void transformPlugin_Configuration(Plugin.Builder builder, Plugin target) {
        Dom newVal = this.transform(target.getConfiguration());
        builder.configuration((Dom)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected PluginExecution transformPluginExecution(PluginExecution target) {
        if (target == null) {
            return null;
        }
        PluginExecution.Builder builder = PluginExecution.newBuilder((PluginExecution)target);
        this.transformPluginExecution_Id(builder, target);
        this.transformPluginExecution_Phase(builder, target);
        this.transformPluginExecution_Goals(builder, target);
        this.transformConfigurationContainer_Inherited((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        this.transformConfigurationContainer_Configuration((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        return builder.build();
    }

    protected void transformPluginExecution_Id(PluginExecution.Builder builder, PluginExecution target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformPluginExecution_Phase(PluginExecution.Builder builder, PluginExecution target) {
        String newVal = this.transform(target.getPhase());
        builder.phase(newVal != target.getPhase() ? newVal : null);
    }

    protected void transformPluginExecution_Goals(PluginExecution.Builder builder, PluginExecution target) {
        builder.goals(this.transform(target.getGoals(), this::transform));
    }

    protected void transformPluginExecution_Inherited(PluginExecution.Builder builder, PluginExecution target) {
        String newVal = this.transform(target.getInherited());
        builder.inherited(newVal != target.getInherited() ? newVal : null);
    }

    protected void transformPluginExecution_Configuration(PluginExecution.Builder builder, PluginExecution target) {
        Dom newVal = this.transform(target.getConfiguration());
        builder.configuration((Dom)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected DependencyManagement transformDependencyManagement(DependencyManagement target) {
        if (target == null) {
            return null;
        }
        DependencyManagement.Builder builder = DependencyManagement.newBuilder((DependencyManagement)target);
        this.transformDependencyManagement_Dependencies(builder, target);
        return builder.build();
    }

    protected void transformDependencyManagement_Dependencies(DependencyManagement.Builder builder, DependencyManagement target) {
        builder.dependencies(this.transform(target.getDependencies(), this::transformDependency));
    }

    protected PluginManagement transformPluginManagement(PluginManagement target) {
        if (target == null) {
            return null;
        }
        PluginManagement.Builder builder = PluginManagement.newBuilder((PluginManagement)target);
        this.transformPluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)target);
        return builder.build();
    }

    protected void transformPluginManagement_Plugins(PluginManagement.Builder builder, PluginManagement target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformPlugin));
    }

    protected Reporting transformReporting(Reporting target) {
        if (target == null) {
            return null;
        }
        Reporting.Builder builder = Reporting.newBuilder((Reporting)target);
        this.transformReporting_ExcludeDefaults(builder, target);
        this.transformReporting_OutputDirectory(builder, target);
        this.transformReporting_Plugins(builder, target);
        return builder.build();
    }

    protected void transformReporting_ExcludeDefaults(Reporting.Builder builder, Reporting target) {
        String newVal = this.transform(target.getExcludeDefaults());
        builder.excludeDefaults(newVal != target.getExcludeDefaults() ? newVal : null);
    }

    protected void transformReporting_OutputDirectory(Reporting.Builder builder, Reporting target) {
        String newVal = this.transform(target.getOutputDirectory());
        builder.outputDirectory(newVal != target.getOutputDirectory() ? newVal : null);
    }

    protected void transformReporting_Plugins(Reporting.Builder builder, Reporting target) {
        builder.plugins(this.transform(target.getPlugins(), this::transformReportPlugin));
    }

    protected Profile transformProfile(Profile target) {
        if (target == null) {
            return null;
        }
        Profile.Builder builder = Profile.newBuilder((Profile)target);
        this.transformProfile_Id(builder, target);
        this.transformProfile_Activation(builder, target);
        this.transformProfile_Build(builder, target);
        this.transformModelBase_Modules((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_DistributionManagement((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Properties((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_DependencyManagement((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Dependencies((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Repositories((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_PluginRepositories((ModelBase.Builder)builder, (ModelBase)target);
        this.transformModelBase_Reporting((ModelBase.Builder)builder, (ModelBase)target);
        return builder.build();
    }

    protected void transformProfile_Id(Profile.Builder builder, Profile target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformProfile_Activation(Profile.Builder builder, Profile target) {
        Activation newVal = this.transformActivation(target.getActivation());
        builder.activation((Activation)(newVal != target.getActivation() ? newVal : null));
    }

    protected void transformProfile_Build(Profile.Builder builder, Profile target) {
        BuildBase newVal = this.transformBuildBase(target.getBuild());
        builder.build((BuildBase)(newVal != target.getBuild() ? newVal : null));
    }

    protected void transformProfile_Modules(Profile.Builder builder, Profile target) {
        builder.modules(this.transform(target.getModules(), this::transform));
    }

    protected void transformProfile_DistributionManagement(Profile.Builder builder, Profile target) {
        DistributionManagement newVal = this.transformDistributionManagement(target.getDistributionManagement());
        builder.distributionManagement((DistributionManagement)(newVal != target.getDistributionManagement() ? newVal : null));
    }

    protected void transformProfile_Properties(Profile.Builder builder, Profile target) {
        Map props = target.getProperties();
        HashMap newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap();
                newProps.putAll(props);
                builder.properties(newProps);
            }
            newProps.put(entry.getKey(), newVal);
        }
    }

    protected void transformProfile_DependencyManagement(Profile.Builder builder, Profile target) {
        DependencyManagement newVal = this.transformDependencyManagement(target.getDependencyManagement());
        builder.dependencyManagement((DependencyManagement)(newVal != target.getDependencyManagement() ? newVal : null));
    }

    protected void transformProfile_Dependencies(Profile.Builder builder, Profile target) {
        builder.dependencies(this.transform(target.getDependencies(), this::transformDependency));
    }

    protected void transformProfile_Repositories(Profile.Builder builder, Profile target) {
        builder.repositories(this.transform(target.getRepositories(), this::transformRepository));
    }

    protected void transformProfile_PluginRepositories(Profile.Builder builder, Profile target) {
        builder.pluginRepositories(this.transform(target.getPluginRepositories(), this::transformRepository));
    }

    protected void transformProfile_Reporting(Profile.Builder builder, Profile target) {
        Reporting newVal = this.transformReporting(target.getReporting());
        builder.reporting((Reporting)(newVal != target.getReporting() ? newVal : null));
    }

    protected Activation transformActivation(Activation target) {
        if (target == null) {
            return null;
        }
        Activation.Builder builder = Activation.newBuilder((Activation)target);
        this.transformActivation_ActiveByDefault(builder, target);
        this.transformActivation_Jdk(builder, target);
        this.transformActivation_Os(builder, target);
        this.transformActivation_Property(builder, target);
        this.transformActivation_File(builder, target);
        return builder.build();
    }

    protected void transformActivation_ActiveByDefault(Activation.Builder builder, Activation target) {
    }

    protected void transformActivation_Jdk(Activation.Builder builder, Activation target) {
        String newVal = this.transform(target.getJdk());
        builder.jdk(newVal != target.getJdk() ? newVal : null);
    }

    protected void transformActivation_Os(Activation.Builder builder, Activation target) {
        ActivationOS newVal = this.transformActivationOS(target.getOs());
        builder.os((ActivationOS)(newVal != target.getOs() ? newVal : null));
    }

    protected void transformActivation_Property(Activation.Builder builder, Activation target) {
        ActivationProperty newVal = this.transformActivationProperty(target.getProperty());
        builder.property((ActivationProperty)(newVal != target.getProperty() ? newVal : null));
    }

    protected void transformActivation_File(Activation.Builder builder, Activation target) {
        ActivationFile newVal = this.transformActivationFile(target.getFile());
        builder.file((ActivationFile)(newVal != target.getFile() ? newVal : null));
    }

    protected ActivationProperty transformActivationProperty(ActivationProperty target) {
        if (target == null) {
            return null;
        }
        ActivationProperty.Builder builder = ActivationProperty.newBuilder((ActivationProperty)target);
        this.transformActivationProperty_Name(builder, target);
        this.transformActivationProperty_Value(builder, target);
        return builder.build();
    }

    protected void transformActivationProperty_Name(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformActivationProperty_Value(ActivationProperty.Builder builder, ActivationProperty target) {
        String newVal = this.transform(target.getValue());
        builder.value(newVal != target.getValue() ? newVal : null);
    }

    protected ActivationOS transformActivationOS(ActivationOS target) {
        if (target == null) {
            return null;
        }
        ActivationOS.Builder builder = ActivationOS.newBuilder((ActivationOS)target);
        this.transformActivationOS_Name(builder, target);
        this.transformActivationOS_Family(builder, target);
        this.transformActivationOS_Arch(builder, target);
        this.transformActivationOS_Version(builder, target);
        return builder.build();
    }

    protected void transformActivationOS_Name(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getName());
        builder.name(newVal != target.getName() ? newVal : null);
    }

    protected void transformActivationOS_Family(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getFamily());
        builder.family(newVal != target.getFamily() ? newVal : null);
    }

    protected void transformActivationOS_Arch(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getArch());
        builder.arch(newVal != target.getArch() ? newVal : null);
    }

    protected void transformActivationOS_Version(ActivationOS.Builder builder, ActivationOS target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected ActivationFile transformActivationFile(ActivationFile target) {
        if (target == null) {
            return null;
        }
        ActivationFile.Builder builder = ActivationFile.newBuilder((ActivationFile)target);
        this.transformActivationFile_Missing(builder, target);
        this.transformActivationFile_Exists(builder, target);
        return builder.build();
    }

    protected void transformActivationFile_Missing(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = this.transform(target.getMissing());
        builder.missing(newVal != target.getMissing() ? newVal : null);
    }

    protected void transformActivationFile_Exists(ActivationFile.Builder builder, ActivationFile target) {
        String newVal = this.transform(target.getExists());
        builder.exists(newVal != target.getExists() ? newVal : null);
    }

    protected ReportPlugin transformReportPlugin(ReportPlugin target) {
        if (target == null) {
            return null;
        }
        ReportPlugin.Builder builder = ReportPlugin.newBuilder((ReportPlugin)target);
        this.transformReportPlugin_GroupId(builder, target);
        this.transformReportPlugin_ArtifactId(builder, target);
        this.transformReportPlugin_Version(builder, target);
        this.transformReportPlugin_ReportSets(builder, target);
        this.transformConfigurationContainer_Inherited((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        this.transformConfigurationContainer_Configuration((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        return builder.build();
    }

    protected void transformReportPlugin_GroupId(ReportPlugin.Builder builder, ReportPlugin target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformReportPlugin_ArtifactId(ReportPlugin.Builder builder, ReportPlugin target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformReportPlugin_Version(ReportPlugin.Builder builder, ReportPlugin target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformReportPlugin_ReportSets(ReportPlugin.Builder builder, ReportPlugin target) {
        builder.reportSets(this.transform(target.getReportSets(), this::transformReportSet));
    }

    protected void transformReportPlugin_Inherited(ReportPlugin.Builder builder, ReportPlugin target) {
        String newVal = this.transform(target.getInherited());
        builder.inherited(newVal != target.getInherited() ? newVal : null);
    }

    protected void transformReportPlugin_Configuration(ReportPlugin.Builder builder, ReportPlugin target) {
        Dom newVal = this.transform(target.getConfiguration());
        builder.configuration((Dom)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected ReportSet transformReportSet(ReportSet target) {
        if (target == null) {
            return null;
        }
        ReportSet.Builder builder = ReportSet.newBuilder((ReportSet)target);
        this.transformReportSet_Id(builder, target);
        this.transformReportSet_Reports(builder, target);
        this.transformConfigurationContainer_Inherited((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        this.transformConfigurationContainer_Configuration((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target);
        return builder.build();
    }

    protected void transformReportSet_Id(ReportSet.Builder builder, ReportSet target) {
        String newVal = this.transform(target.getId());
        builder.id(newVal != target.getId() ? newVal : null);
    }

    protected void transformReportSet_Reports(ReportSet.Builder builder, ReportSet target) {
        builder.reports(this.transform(target.getReports(), this::transform));
    }

    protected void transformReportSet_Inherited(ReportSet.Builder builder, ReportSet target) {
        String newVal = this.transform(target.getInherited());
        builder.inherited(newVal != target.getInherited() ? newVal : null);
    }

    protected void transformReportSet_Configuration(ReportSet.Builder builder, ReportSet target) {
        Dom newVal = this.transform(target.getConfiguration());
        builder.configuration((Dom)(newVal != target.getConfiguration() ? newVal : null));
    }

    protected Prerequisites transformPrerequisites(Prerequisites target) {
        if (target == null) {
            return null;
        }
        Prerequisites.Builder builder = Prerequisites.newBuilder((Prerequisites)target);
        this.transformPrerequisites_Maven(builder, target);
        return builder.build();
    }

    protected void transformPrerequisites_Maven(Prerequisites.Builder builder, Prerequisites target) {
        String newVal = this.transform(target.getMaven());
        builder.maven(newVal != target.getMaven() ? newVal : null);
    }

    protected Relocation transformRelocation(Relocation target) {
        if (target == null) {
            return null;
        }
        Relocation.Builder builder = Relocation.newBuilder((Relocation)target);
        this.transformRelocation_GroupId(builder, target);
        this.transformRelocation_ArtifactId(builder, target);
        this.transformRelocation_Version(builder, target);
        this.transformRelocation_Message(builder, target);
        return builder.build();
    }

    protected void transformRelocation_GroupId(Relocation.Builder builder, Relocation target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformRelocation_ArtifactId(Relocation.Builder builder, Relocation target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformRelocation_Version(Relocation.Builder builder, Relocation target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected void transformRelocation_Message(Relocation.Builder builder, Relocation target) {
        String newVal = this.transform(target.getMessage());
        builder.message(newVal != target.getMessage() ? newVal : null);
    }

    protected Extension transformExtension(Extension target) {
        if (target == null) {
            return null;
        }
        Extension.Builder builder = Extension.newBuilder((Extension)target);
        this.transformExtension_GroupId(builder, target);
        this.transformExtension_ArtifactId(builder, target);
        this.transformExtension_Version(builder, target);
        return builder.build();
    }

    protected void transformExtension_GroupId(Extension.Builder builder, Extension target) {
        String newVal = this.transform(target.getGroupId());
        builder.groupId(newVal != target.getGroupId() ? newVal : null);
    }

    protected void transformExtension_ArtifactId(Extension.Builder builder, Extension target) {
        String newVal = this.transform(target.getArtifactId());
        builder.artifactId(newVal != target.getArtifactId() ? newVal : null);
    }

    protected void transformExtension_Version(Extension.Builder builder, Extension target) {
        String newVal = this.transform(target.getVersion());
        builder.version(newVal != target.getVersion() ? newVal : null);
    }

    protected <T> List<T> transform(List<T> list, Function<T, T> transformer) {
        ArrayList<T> newList = null;
        for (int i = 0; i < list.size(); ++i) {
            T newVal = transformer.apply(list.get(i));
            if (newVal == list.get(i)) continue;
            if (newList == null) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newVal);
        }
        return newList;
    }

    protected Dom transform(Dom node) {
        if (node != null) {
            Xpp3Dom xpp = new Xpp3Dom(node);
            this.transform(xpp);
            return xpp.getDom();
        }
        return node;
    }

    protected void transform(Xpp3Dom dom) {
        if (dom != null) {
            String val;
            String org = dom.getValue();
            if (org != (val = this.transform(org))) {
                dom.setValue(val);
            }
            for (String attr : dom.getAttributeNames()) {
                org = dom.getAttribute(attr);
                if (org == (val = this.transform(org))) continue;
                dom.setAttribute(attr, val);
            }
            int l = dom.getChildCount();
            for (int i = 0; i < l; ++i) {
                this.transform(dom.getChild(i));
            }
        }
    }
}

