/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.WrapperList;

@Generated
public class Plugin
extends ConfigurationContainer
implements Serializable,
Cloneable {
    private Map<String, PluginExecution> executionMap = null;

    public Plugin() {
        this(org.apache.maven.api.model.Plugin.newInstance());
    }

    public Plugin(org.apache.maven.api.model.Plugin delegate) {
        this(delegate, (BaseObject)null);
    }

    public Plugin(org.apache.maven.api.model.Plugin delegate, BaseObject parent) {
        super((org.apache.maven.api.model.ConfigurationContainer)delegate, parent);
    }

    @Override
    public Plugin clone() {
        return new Plugin(this.getDelegate());
    }

    public org.apache.maven.api.model.Plugin getDelegate() {
        return (org.apache.maven.api.model.Plugin)super.getDelegate();
    }

    public String getGroupId() {
        return this.getDelegate().getGroupId();
    }

    public void setGroupId(String groupId) {
        if (!Objects.equals(groupId, this.getDelegate().getGroupId())) {
            this.update(this.getDelegate().withGroupId(groupId));
        }
    }

    public String getArtifactId() {
        return this.getDelegate().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        if (!Objects.equals(artifactId, this.getDelegate().getArtifactId())) {
            this.update(this.getDelegate().withArtifactId(artifactId));
        }
    }

    public String getVersion() {
        return this.getDelegate().getVersion();
    }

    public void setVersion(String version) {
        if (!Objects.equals(version, this.getDelegate().getVersion())) {
            this.update(this.getDelegate().withVersion(version));
        }
    }

    public String getExtensions() {
        return this.getDelegate().getExtensions();
    }

    public void setExtensions(String extensions) {
        if (!Objects.equals(extensions, this.getDelegate().getExtensions())) {
            this.update(this.getDelegate().withExtensions(extensions));
        }
    }

    @Nonnull
    public List<PluginExecution> getExecutions() {
        return new WrapperList<PluginExecution, org.apache.maven.api.model.PluginExecution>(() -> this.getDelegate().getExecutions(), l -> this.update(this.getDelegate().withExecutions((Collection)l)), d -> new PluginExecution((org.apache.maven.api.model.PluginExecution)d, (BaseObject)this), PluginExecution::getDelegate);
    }

    public void setExecutions(List<PluginExecution> executions) {
        if (!Objects.equals(executions, this.getDelegate().getExecutions())) {
            this.update(this.getDelegate().withExecutions((Collection)executions.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            executions.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addExecution(PluginExecution execution) {
        this.update(this.getDelegate().withExecutions((Collection)Stream.concat(this.getDelegate().getExecutions().stream(), Stream.of(execution.getDelegate())).collect(Collectors.toList())));
        execution.childrenTracking = this::replace;
    }

    public void removeExecution(PluginExecution execution) {
        this.update(this.getDelegate().withExecutions((Collection)this.getDelegate().getExecutions().stream().filter(e -> !Objects.equals(e, execution)).collect(Collectors.toList())));
        execution.childrenTracking = null;
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        return new WrapperList<Dependency, org.apache.maven.api.model.Dependency>(() -> this.getDelegate().getDependencies(), l -> this.update(this.getDelegate().withDependencies((Collection)l)), d -> new Dependency((org.apache.maven.api.model.Dependency)d, (BaseObject)this), Dependency::getDelegate);
    }

    public void setDependencies(List<Dependency> dependencies) {
        if (!Objects.equals(dependencies, this.getDelegate().getDependencies())) {
            this.update(this.getDelegate().withDependencies((Collection)dependencies.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            dependencies.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addDependency(Dependency dependency) {
        this.update(this.getDelegate().withDependencies((Collection)Stream.concat(this.getDelegate().getDependencies().stream(), Stream.of(dependency.getDelegate())).collect(Collectors.toList())));
        dependency.childrenTracking = this::replace;
    }

    public void removeDependency(Dependency dependency) {
        this.update(this.getDelegate().withDependencies((Collection)this.getDelegate().getDependencies().stream().filter(e -> !Objects.equals(e, dependency)).collect(Collectors.toList())));
        dependency.childrenTracking = null;
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.Plugin.newBuilder((org.apache.maven.api.model.Plugin)this.getDelegate(), (boolean)true).location(key, location.toApiLocation()).build());
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getExecutions().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getExecutions());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.PluginExecution)newDelegate : d);
            this.update(this.getDelegate().withExecutions(list));
            return true;
        }
        if (this.getDelegate().getDependencies().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getDependencies());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Dependency)newDelegate : d);
            this.update(this.getDelegate().withDependencies(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.Plugin> pluginToApiV4(List<Plugin> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.Plugin, Plugin>(list, Plugin::getDelegate, Plugin::new) : null;
    }

    public static List<Plugin> pluginToApiV3(List<org.apache.maven.api.model.Plugin> list) {
        return list != null ? new WrapperList<Plugin, org.apache.maven.api.model.Plugin>(list, Plugin::new, Plugin::getDelegate) : null;
    }

    public boolean isExtensions() {
        return this.getExtensions() != null ? Boolean.parseBoolean(this.getExtensions()) : false;
    }

    public void setExtensions(boolean extensions) {
        this.setExtensions(String.valueOf(extensions));
    }

    public void flushExecutionMap() {
        this.executionMap = null;
    }

    public Map<String, PluginExecution> getExecutionsAsMap() {
        if (this.executionMap == null) {
            this.executionMap = new LinkedHashMap<String, PluginExecution>();
            for (PluginExecution exec : this.getExecutions()) {
                if (this.executionMap.containsKey(exec.getId())) {
                    throw new IllegalStateException("You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: '" + exec.getId() + "'\nPlugin:'" + this.getKey() + "'\n\n");
                }
                this.executionMap.put(exec.getId(), exec);
            }
        }
        return this.executionMap;
    }

    public String getId() {
        StringBuilder id = new StringBuilder(128);
        id.append(this.getGroupId() == null ? "[unknown-group-id]" : this.getGroupId());
        id.append(":");
        id.append(this.getArtifactId() == null ? "[unknown-artifact-id]" : this.getArtifactId());
        id.append(":");
        id.append(this.getVersion() == null ? "[unknown-version]" : this.getVersion());
        return id.toString();
    }

    public String getKey() {
        return Plugin.constructKey(this.getGroupId(), this.getArtifactId());
    }

    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin)other;
            return this.getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Plugin [" + this.getKey() + "]";
    }
}

