/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.4.0,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * Build configuration in a profile.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class BuildBase
    extends PluginConfiguration
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The default goal (or phase in Maven 2) to execute when none
     * is specified for
     *             the project. Note that in case of a multi-module
     * build, only the default goal of the top-level
     *             project is relevant, i.e. the default goals of
     * child modules are ignored. Since Maven 3,
     *             multiple goals/phases can be separated by
     * whitespace.
     */
    private String defaultGoal;

    /**
     * Field resources.
     */
    private java.util.List<Resource> resources;

    /**
     * Field testResources.
     */
    private java.util.List<Resource> testResources;

    /**
     * 
     *             The directory where all files generated by the
     * build are placed.
     *             The default value is <code>target</code>.
     *           
     */
    private String directory;

    /**
     * 
     *             
     *             The filename (excluding the extension, and with
     * no path information) that
     *             the produced artifact will be called.
     *             The default value is
     * <code>${artifactId}-${version}</code>.
     *             
     *           
     */
    private String finalName;

    /**
     * Field filters.
     */
    private java.util.List<String> filters;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFilter.
     * 
     * @param string a string object.
     */
    public void addFilter( String string )
    {
        getFilters().add( string );
    } //-- void addFilter( String )

    /**
     * Method addResource.
     * 
     * @param resource a resource object.
     */
    public void addResource( Resource resource )
    {
        getResources().add( resource );
    } //-- void addResource( Resource )

    /**
     * Method addTestResource.
     * 
     * @param resource a resource object.
     */
    public void addTestResource( Resource resource )
    {
        getTestResources().add( resource );
    } //-- void addTestResource( Resource )

    /**
     * Method clone.
     * 
     * @return BuildBase
     */
    public BuildBase clone()
    {
        try
        {
            BuildBase copy = (BuildBase) super.clone();

            if ( this.resources != null )
            {
                copy.resources = new java.util.ArrayList<Resource>();
                for ( Resource item : this.resources )
                {
                    copy.resources.add( ( (Resource) item).clone() );
                }
            }

            if ( this.testResources != null )
            {
                copy.testResources = new java.util.ArrayList<Resource>();
                for ( Resource item : this.testResources )
                {
                    copy.testResources.add( ( (Resource) item).clone() );
                }
            }

            if ( this.filters != null )
            {
                copy.filters = new java.util.ArrayList<String>();
                copy.filters.addAll( this.filters );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- BuildBase clone()

    /**
     * Get the default goal (or phase in Maven 2) to execute when
     * none is specified for
     *             the project. Note that in case of a multi-module
     * build, only the default goal of the top-level
     *             project is relevant, i.e. the default goals of
     * child modules are ignored. Since Maven 3,
     *             multiple goals/phases can be separated by
     * whitespace.
     * 
     * @return String
     */
    public String getDefaultGoal()
    {
        return this.defaultGoal;
    } //-- String getDefaultGoal()

    /**
     * Get the directory where all files generated by the build are
     * placed.
     *             The default value is <code>target</code>.
     * 
     * @return String
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory()

    /**
     * Method getFilters.
     * 
     * @return List
     */
    public java.util.List<String> getFilters()
    {
        if ( this.filters == null )
        {
            this.filters = new java.util.ArrayList<String>();
        }

        return this.filters;
    } //-- java.util.List<String> getFilters()

    /**
     * Get the filename (excluding the extension, and with no path
     * information) that
     *             the produced artifact will be called.
     *             The default value is
     * <code>${artifactId}-${version}</code>.
     * 
     * @return String
     */
    public String getFinalName()
    {
        return this.finalName;
    } //-- String getFinalName()

    /**
     * Method getResources.
     * 
     * @return List
     */
    public java.util.List<Resource> getResources()
    {
        if ( this.resources == null )
        {
            this.resources = new java.util.ArrayList<Resource>();
        }

        return this.resources;
    } //-- java.util.List<Resource> getResources()

    /**
     * Method getTestResources.
     * 
     * @return List
     */
    public java.util.List<Resource> getTestResources()
    {
        if ( this.testResources == null )
        {
            this.testResources = new java.util.ArrayList<Resource>();
        }

        return this.testResources;
    } //-- java.util.List<Resource> getTestResources()

    /**
     * Method removeFilter.
     * 
     * @param string a string object.
     */
    public void removeFilter( String string )
    {
        getFilters().remove( string );
    } //-- void removeFilter( String )

    /**
     * Method removeResource.
     * 
     * @param resource a resource object.
     */
    public void removeResource( Resource resource )
    {
        getResources().remove( resource );
    } //-- void removeResource( Resource )

    /**
     * Method removeTestResource.
     * 
     * @param resource a resource object.
     */
    public void removeTestResource( Resource resource )
    {
        getTestResources().remove( resource );
    } //-- void removeTestResource( Resource )

    /**
     * Set the default goal (or phase in Maven 2) to execute when
     * none is specified for
     *             the project. Note that in case of a multi-module
     * build, only the default goal of the top-level
     *             project is relevant, i.e. the default goals of
     * child modules are ignored. Since Maven 3,
     *             multiple goals/phases can be separated by
     * whitespace.
     * 
     * @param defaultGoal a defaultGoal object.
     */
    public void setDefaultGoal( String defaultGoal )
    {
        this.defaultGoal = defaultGoal;
    } //-- void setDefaultGoal( String )

    /**
     * Set the directory where all files generated by the build are
     * placed.
     *             The default value is <code>target</code>.
     * 
     * @param directory a directory object.
     */
    public void setDirectory( String directory )
    {
        this.directory = directory;
    } //-- void setDirectory( String )

    /**
     * Set the list of filter properties files that are used when
     * filtering is enabled.
     * 
     * @param filters a filters object.
     */
    public void setFilters( java.util.List<String> filters )
    {
        this.filters = filters;
    } //-- void setFilters( java.util.List )

    /**
     * Set the filename (excluding the extension, and with no path
     * information) that
     *             the produced artifact will be called.
     *             The default value is
     * <code>${artifactId}-${version}</code>.
     * 
     * @param finalName a finalName object.
     */
    public void setFinalName( String finalName )
    {
        this.finalName = finalName;
    } //-- void setFinalName( String )

    /**
     * Set this element describes all of the classpath resources
     * such as properties
     *             files associated with a project. These resources
     * are often included in the final
     *             package.
     *             The default value is
     * <code>src/main/resources</code>.
     * 
     * @param resources a resources object.
     */
    public void setResources( java.util.List<Resource> resources )
    {
        this.resources = resources;
    } //-- void setResources( java.util.List )

    /**
     * Set this element describes all of the classpath resources
     * such as properties
     *             files associated with a project's unit tests.
     *             The default value is
     * <code>src/test/resources</code>.
     * 
     * @param testResources a testResources object.
     */
    public void setTestResources( java.util.List<Resource> testResources )
    {
        this.testResources = testResources;
    } //-- void setTestResources( java.util.List )

    
            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "BuildBase {" + super.toString() + "}";
    }
            
          
}
