/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Download policy.
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryPolicy implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Whether to use this repository for downloading this type of
     * artifact.
     */
    private boolean enabled = true;

    /**
     * 
     *             
     *             The frequency for downloading updates - can be
     *             <code>always,</code>
     *             <code>daily</code>
     *             (default),
     *             <code>interval:XXX</code>
     *             (in minutes) or
     *             <code>never</code>
     *             (only if it doesn't exist locally).
     *             
     *           
     */
    private String updatePolicy;

    /**
     * 
     *             
     *             What to do when verification of an artifact
     * checksum fails. Valid values are
     *             <code>ignore</code>
     *             ,
     *             <code>fail</code>
     *             or
     *             <code>warn</code>
     *             (the default).
     *             
     *           
     */
    private String checksumPolicy;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             
     *             What to do when verification of an artifact
     * checksum fails. Valid values are
     *             <code>ignore</code>
     *             ,
     *             <code>fail</code>
     *             or
     *             <code>warn</code>
     *             (the default).
     *             
     *           
     * 
     * @return String
     */
    public String getChecksumPolicy()
    {
        return this.checksumPolicy;
    } //-- String getChecksumPolicy() 

    /**
     * Get 
     *             
     *             The frequency for downloading updates - can be
     *             <code>always,</code>
     *             <code>daily</code>
     *             (default),
     *             <code>interval:XXX</code>
     *             (in minutes) or
     *             <code>never</code>
     *             (only if it doesn't exist locally).
     *             
     *           
     * 
     * @return String
     */
    public String getUpdatePolicy()
    {
        return this.updatePolicy;
    } //-- String getUpdatePolicy() 

    /**
     * Get whether to use this repository for downloading this type
     * of artifact.
     * 
     * @return boolean
     */
    public boolean isEnabled()
    {
        return this.enabled;
    } //-- boolean isEnabled() 

    /**
     * Set 
     *             
     *             What to do when verification of an artifact
     * checksum fails. Valid values are
     *             <code>ignore</code>
     *             ,
     *             <code>fail</code>
     *             or
     *             <code>warn</code>
     *             (the default).
     *             
     *           
     * 
     * @param checksumPolicy
     */
    public void setChecksumPolicy( String checksumPolicy )
    {
        this.checksumPolicy = checksumPolicy;
    } //-- void setChecksumPolicy( String ) 

    /**
     * Set whether to use this repository for downloading this type
     * of artifact.
     * 
     * @param enabled
     */
    public void setEnabled( boolean enabled )
    {
        this.enabled = enabled;
    } //-- void setEnabled( boolean ) 

    /**
     * Set 
     *             
     *             The frequency for downloading updates - can be
     *             <code>always,</code>
     *             <code>daily</code>
     *             (default),
     *             <code>interval:XXX</code>
     *             (in minutes) or
     *             <code>never</code>
     *             (only if it doesn't exist locally).
     *             
     *           
     * 
     * @param updatePolicy
     */
    public void setUpdatePolicy( String updatePolicy )
    {
        this.updatePolicy = updatePolicy;
    } //-- void setUpdatePolicy( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
