/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * This is an activator which will detect an operating system's
 * attributes in order
 *         to activate its profile.
 * 
 * @version $Revision$ $Date$
 */
public class ActivationOS implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             The name of the operating system to be used to
     * activate the profile. This must be an exact match
     *             of the <code>${os.name}</code> Java property,
     * such as <code>Windows XP</code>.
     *             
     *           
     */
    private String name;

    /**
     * 
     *             
     *             The general family of the OS to be used to
     * activate the profile, such as
     *             <code>windows</code> or <code>unix</code>.
     *             
     *           
     */
    private String family;

    /**
     * The architecture of the operating system to be used to
     * activate the
     *           profile.
     */
    private String arch;

    /**
     * The version of the operating system to be used to activate
     * the
     *           profile.
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the architecture of the operating system to be used to
     * activate the
     *           profile.
     * 
     * @return String
     */
    public String getArch()
    {
        return this.arch;
    } //-- String getArch() 

    /**
     * Get 
     *             
     *             The general family of the OS to be used to
     * activate the profile, such as
     *             <code>windows</code> or <code>unix</code>.
     *             
     *           
     * 
     * @return String
     */
    public String getFamily()
    {
        return this.family;
    } //-- String getFamily() 

    /**
     * Get 
     *             
     *             The name of the operating system to be used to
     * activate the profile. This must be an exact match
     *             of the <code>${os.name}</code> Java property,
     * such as <code>Windows XP</code>.
     *             
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the version of the operating system to be used to
     * activate the
     *           profile.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set the architecture of the operating system to be used to
     * activate the
     *           profile.
     * 
     * @param arch
     */
    public void setArch( String arch )
    {
        this.arch = arch;
    } //-- void setArch( String ) 

    /**
     * Set 
     *             
     *             The general family of the OS to be used to
     * activate the profile, such as
     *             <code>windows</code> or <code>unix</code>.
     *             
     *           
     * 
     * @param family
     */
    public void setFamily( String family )
    {
        this.family = family;
    } //-- void setFamily( String ) 

    /**
     * Set 
     *             
     *             The name of the operating system to be used to
     * activate the profile. This must be an exact match
     *             of the <code>${os.name}</code> Java property,
     * such as <code>Windows XP</code>.
     *             
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String ) 

    /**
     * Set the version of the operating system to be used to
     * activate the
     *           profile.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
