/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;plugin&gt;</code> element contains
 * informations required for a plugin.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Plugin extends ConfigurationContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId = "org.apache.maven.plugins";

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field extensions
     */
    private boolean extensions = false;

    /**
     * Field executions
     */
    private java.util.List executions;

    /**
     * Field dependencies
     */
    private java.util.List dependencies;

    /**
     * Field goals
     */
    private Object goals;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method addExecution
     * 
     * @param pluginExecution
     */
    public void addExecution(PluginExecution pluginExecution)
    {
        getExecutions().add( pluginExecution );
    } //-- void addExecution(PluginExecution) 

    /**
     * Get 
     *             The artifact ID of the plugin in the repository.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method getExecutions
     */
    public java.util.List getExecutions()
    {
        if ( this.executions == null )
        {
            this.executions = new java.util.ArrayList();
        }
        
        return this.executions;
    } //-- java.util.List getExecutions() 

    /**
     * Get 
     *             
     *             <b>Deprecated</b>. Unused by Maven.
     *             
     *           
     */
    public Object getGoals()
    {
        return this.goals;
    } //-- Object getGoals() 

    /**
     * Get 
     *             The group ID of the plugin in the repository.
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             
     *             The version (or valid range of verisons) of the
     * plugin to be used.
     *             
     *           
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get 
     *             Whether to load Maven extensions (such as
     * packaging and type
     *             handlers) from this plugin. For performance
     * reasons, this
     *             should only be enabled when necessary.
     *           
     */
    public boolean isExtensions()
    {
        return this.extensions;
    } //-- boolean isExtensions() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Method removeExecution
     * 
     * @param pluginExecution
     */
    public void removeExecution(PluginExecution pluginExecution)
    {
        getExecutions().remove( pluginExecution );
    } //-- void removeExecution(PluginExecution) 

    /**
     * Set 
     *             The artifact ID of the plugin in the repository.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             Additional dependencies that this project needs
     * to introduce
     *             to the plugin's classloader.
     *           
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 

    /**
     * Set 
     *             Multiple specifications of a set of goals to
     * execute during
     *             the build lifecycle, each having (possibly)
     * different
     *             configuration.
     *           
     * 
     * @param executions
     */
    public void setExecutions(java.util.List executions)
    {
        this.executions = executions;
    } //-- void setExecutions(java.util.List) 

    /**
     * Set 
     *             Whether to load Maven extensions (such as
     * packaging and type
     *             handlers) from this plugin. For performance
     * reasons, this
     *             should only be enabled when necessary.
     *           
     * 
     * @param extensions
     */
    public void setExtensions(boolean extensions)
    {
        this.extensions = extensions;
    } //-- void setExtensions(boolean) 

    /**
     * Set 
     *             
     *             <b>Deprecated</b>. Unused by Maven.
     *             
     *           
     * 
     * @param goals
     */
    public void setGoals(Object goals)
    {
        this.goals = goals;
    } //-- void setGoals(Object) 

    /**
     * Set 
     *             The group ID of the plugin in the repository.
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             
     *             The version (or valid range of verisons) of the
     * plugin to be used.
     *             
     *           
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            
    private java.util.Map executionMap = null;

    /**
     * Reset the <code>executionMap</code> field to <code>null</code>
     */
    public void flushExecutionMap()
    {
        this.executionMap = null;
    }

    /**
     * @return a Map of executions field with <code>PluginExecution#getId()</code> as key
     * @see org.apache.maven.model.PluginExecution#getId()
     */
    public java.util.Map getExecutionsAsMap()
    {
        if ( executionMap == null )
        {
            executionMap = new java.util.HashMap();
            if ( getExecutions() != null )
            {
                for ( java.util.Iterator i = getExecutions().iterator(); i.hasNext(); )
                {
                    PluginExecution exec = (PluginExecution) i.next();

                    if ( executionMap.containsKey( exec.getId() ) )
                    {
                        throw new IllegalStateException( "You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: \'" + exec.getId() + "\'\nPlugin:\'" + getKey() + "\'\n\n" );
                    }

                    executionMap.put( exec.getId(), exec );
                }
            }
        }

        return executionMap;
    }

    /**
     * @return the key of the plugin, ie <code>groupId:artifactId</code>
     */
    public String getKey()
    {
        return constructKey( groupId, artifactId );
    }

    /**
     * @param groupId
     * @param artifactId
     * @return the key of the plugin, ie <code>groupId:artifactId</code>
     */
    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object other )
    {
        if ( other instanceof Plugin )
        {
            Plugin otherPlugin = (Plugin) other;

            return getKey().equals( otherPlugin.getKey() );
        }

        return false;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        return getKey().hashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Plugin [" + getKey() + "]";
    }
            
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
