/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * Section for management of reports and their configuration.
 * 
 * @version $Revision$ $Date$
 */
public class Reporting implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field excludeDefaults
     */
    private boolean excludeDefaults = false;

    /**
     * Field outputDirectory
     */
    private String outputDirectory;

    /**
     * Field plugins
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin
     * 
     * @param reportPlugin
     */
    public void addPlugin(ReportPlugin reportPlugin)
    {
        getPlugins().add( reportPlugin );
    } //-- void addPlugin(ReportPlugin) 

    /**
     * Get 
     *             Where to store all of the generated reports. The
     * default is
     *             <code>${project.build.directory}/site</code>
     *             .
     *           
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory() 

    /**
     * Method getPlugins
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Get If true, then the default reports are not included in
     * the site generation. This includes the
     *             reports in the "Project Info" menu.
     */
    public boolean isExcludeDefaults()
    {
        return this.excludeDefaults;
    } //-- boolean isExcludeDefaults() 

    /**
     * Method removePlugin
     * 
     * @param reportPlugin
     */
    public void removePlugin(ReportPlugin reportPlugin)
    {
        getPlugins().remove( reportPlugin );
    } //-- void removePlugin(ReportPlugin) 

    /**
     * Set If true, then the default reports are not included in
     * the site generation. This includes the
     *             reports in the "Project Info" menu.
     * 
     * @param excludeDefaults
     */
    public void setExcludeDefaults(boolean excludeDefaults)
    {
        this.excludeDefaults = excludeDefaults;
    } //-- void setExcludeDefaults(boolean) 

    /**
     * Set 
     *             Where to store all of the generated reports. The
     * default is
     *             <code>${project.build.directory}/site</code>
     *             .
     *           
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory(String outputDirectory)
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory(String) 

    /**
     * Set The reporting plugins to use and their configuration.
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 


    java.util.Map reportPluginMap;

    public void flushReportPluginMap()
    {
        this.reportPluginMap = null;
    }

    public java.util.Map getReportPluginsAsMap()
    {
        if ( reportPluginMap == null )
        {
            reportPluginMap = new java.util.HashMap();
            if ( getPlugins() != null )
            {
                for ( java.util.Iterator it = getPlugins().iterator(); it.hasNext(); )
                {
                    ReportPlugin reportPlugin = (ReportPlugin) it.next();
                    reportPluginMap.put( reportPlugin.getKey(), reportPlugin );
                }
            }
        }
        return reportPluginMap;
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
