/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A repository contains the information needed for establishing
 * connections with
 *         remote repository.
 * 
 * @version $Revision$ $Date$
 */
public class Repository extends RepositoryBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * How to handle downloading of releases from this repository.
     */
    private RepositoryPolicy releases;

    /**
     * How to handle downloading of snapshots from this repository.
     */
    private RepositoryPolicy snapshots;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get how to handle downloading of releases from this
     * repository.
     * 
     * @return RepositoryPolicy
     */
    public RepositoryPolicy getReleases()
    {
        return this.releases;
    } //-- RepositoryPolicy getReleases() 

    /**
     * Get how to handle downloading of snapshots from this
     * repository.
     * 
     * @return RepositoryPolicy
     */
    public RepositoryPolicy getSnapshots()
    {
        return this.snapshots;
    } //-- RepositoryPolicy getSnapshots() 

    /**
     * Set how to handle downloading of releases from this
     * repository.
     * 
     * @param releases
     */
    public void setReleases( RepositoryPolicy releases )
    {
        this.releases = releases;
    } //-- void setReleases( RepositoryPolicy ) 

    /**
     * Set how to handle downloading of snapshots from this
     * repository.
     * 
     * @param snapshots
     */
    public void setSnapshots( RepositoryPolicy snapshots )
    {
        this.snapshots = snapshots;
    } //-- void setSnapshots( RepositoryPolicy ) 


            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object obj )
    {
        return super.equals( obj );
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
