/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Contains the plugins management informations for the project.
 * 
 * @version $Revision$ $Date$
 */
public class PluginConfiguration extends PluginContainer 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Default plugin information to be made available for
     * reference by projects
     *             derived from this one. This plugin configuration
     * will not be resolved or bound to the
     *             lifecycle unless referenced. Any local
     * configuration for a given plugin will override
     *             the plugin's entire definition here.
     */
    private PluginManagement pluginManagement;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get default plugin information to be made available for
     * reference by projects
     *             derived from this one. This plugin configuration
     * will not be resolved or bound to the
     *             lifecycle unless referenced. Any local
     * configuration for a given plugin will override
     *             the plugin's entire definition here.
     * 
     * @return PluginManagement
     */
    public PluginManagement getPluginManagement()
    {
        return this.pluginManagement;
    } //-- PluginManagement getPluginManagement() 

    /**
     * Set default plugin information to be made available for
     * reference by projects
     *             derived from this one. This plugin configuration
     * will not be resolved or bound to the
     *             lifecycle unless referenced. Any local
     * configuration for a given plugin will override
     *             the plugin's entire definition here.
     * 
     * @param pluginManagement
     */
    public void setPluginManagement( PluginManagement pluginManagement )
    {
        this.pluginManagement = pluginManagement;
    } //-- void setPluginManagement( PluginManagement ) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
