/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Repository contains the information needed for deploying to the
 * remote
 *         repository.
 * 
 * @version $Revision$ $Date$
 */
public class DeploymentRepository extends RepositoryBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Whether to assign snapshots a unique version comprised of
     * the timestamp and
     *             build number, or to use the same version each
     * time.
     */
    private boolean uniqueVersion = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get whether to assign snapshots a unique version comprised
     * of the timestamp and
     *             build number, or to use the same version each
     * time.
     * 
     * @return boolean
     */
    public boolean isUniqueVersion()
    {
        return this.uniqueVersion;
    } //-- boolean isUniqueVersion() 

    /**
     * Set whether to assign snapshots a unique version comprised
     * of the timestamp and
     *             build number, or to use the same version each
     * time.
     * 
     * @param uniqueVersion
     */
    public void setUniqueVersion( boolean uniqueVersion )
    {
        this.uniqueVersion = uniqueVersion;
    } //-- void setUniqueVersion( boolean ) 


            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object obj )
    {
        return super.equals( obj );
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
