/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.maven.model.transform.RelativeProject;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.apache.maven.model.transform.pull.NodeBufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

class ParentXMLFilter
extends NodeBufferingParser {
    private final Function<Path, Optional<RelativeProject>> relativePathMapper;
    private final Path projectPath;

    ParentXMLFilter(XmlPullParser parser, Function<Path, Optional<RelativeProject>> relativePathMapper, Path projectPath) {
        super(parser, "parent");
        this.relativePathMapper = relativePathMapper;
        this.projectPath = projectPath;
    }

    @Override
    protected void process(List<BufferingParser.Event> buffer) {
        String tagName = null;
        String groupId = null;
        String artifactId = null;
        String version = null;
        String relativePath = null;
        String whitespaceAfterParentStart = "";
        boolean hasVersion = false;
        boolean hasRelativePath = false;
        for (int i = 0; i < buffer.size(); ++i) {
            Optional<Object> resolvedParent;
            BufferingParser.Event event = buffer.get(i);
            if (event.event == 2) {
                tagName = event.name;
                hasVersion |= "version".equals(tagName);
                hasRelativePath |= "relativePath".equals(tagName);
                continue;
            }
            if (event.event == 4) {
                if (event.text.matches("\\s+")) {
                    if (!whitespaceAfterParentStart.isEmpty()) continue;
                    whitespaceAfterParentStart = event.text;
                    continue;
                }
                if ("groupId".equals(tagName)) {
                    groupId = ParentXMLFilter.nullSafeAppend(groupId, event.text);
                    continue;
                }
                if ("artifactId".equals(tagName)) {
                    artifactId = ParentXMLFilter.nullSafeAppend(artifactId, event.text);
                    continue;
                }
                if ("relativePath".equals(tagName)) {
                    relativePath = ParentXMLFilter.nullSafeAppend(relativePath, event.text);
                    continue;
                }
                if (!"version".equals(tagName)) continue;
                version = ParentXMLFilter.nullSafeAppend(version, event.text);
                continue;
            }
            if (event.event != 3 || !"parent".equals(event.name)) continue;
            if (!(hasVersion || hasRelativePath && relativePath == null)) {
                Path relPath = Paths.get(Objects.toString(relativePath, "../pom.xml"), new String[0]);
                resolvedParent = this.resolveRelativePath(relPath, groupId, artifactId);
            } else {
                resolvedParent = Optional.empty();
            }
            if (hasVersion || !resolvedParent.isPresent()) break;
            int pos = buffer.get((int)(i - 1)).event == 4 ? i - 1 : i;
            BufferingParser.Event e = new BufferingParser.Event();
            e.event = 4;
            e.text = whitespaceAfterParentStart;
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 2;
            e.namespace = buffer.get((int)0).namespace;
            e.prefix = buffer.get((int)0).prefix;
            e.name = "version";
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 4;
            e.text = ((RelativeProject)resolvedParent.get()).getVersion();
            buffer.add(pos++, e);
            e = new BufferingParser.Event();
            e.event = 3;
            e.name = "version";
            e.namespace = buffer.get((int)0).namespace;
            e.prefix = buffer.get((int)0).prefix;
            buffer.add(pos++, e);
            break;
        }
        buffer.forEach(x$0 -> this.pushEvent((BufferingParser.Event)x$0));
    }

    protected Optional<RelativeProject> resolveRelativePath(Path relativePath, String groupId, String artifactId) {
        RelativeProject project;
        Optional<RelativeProject> mappedProject;
        Path pomPath = this.projectPath.resolve(relativePath);
        if (Files.isDirectory(pomPath, new LinkOption[0])) {
            pomPath = pomPath.resolve("pom.xml");
        }
        if ((mappedProject = this.relativePathMapper.apply(pomPath.normalize())).isPresent() && Objects.equals(groupId, (project = mappedProject.get()).getGroupId()) && Objects.equals(artifactId, project.getArtifactId())) {
            return mappedProject;
        }
        return Optional.empty();
    }
}

