/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.xml.sax.filter.BuildPomXMLFilterFactory;
import org.apache.maven.xml.sax.filter.RelativeProject;

public class DefaultBuildPomXMLFilterFactory
extends BuildPomXMLFilterFactory {
    private final TransformerContext context;

    public DefaultBuildPomXMLFilterFactory(TransformerContext context) {
        this.context = context;
    }

    public final TransformerContext getContext() {
        return this.context;
    }

    protected Function<Path, Optional<RelativeProject>> getRelativePathMapper() {
        return p -> Optional.ofNullable(this.context.getRawModel((Path)p)).map(m -> DefaultBuildPomXMLFilterFactory.toRelativeProject(m));
    }

    protected BiFunction<String, String, String> getDependencyKeyToVersionMapper() {
        return (g, a) -> Optional.ofNullable(this.context.getRawModel((String)g, (String)a)).map(m -> DefaultBuildPomXMLFilterFactory.toVersion(m)).orElse(null);
    }

    private static RelativeProject toRelativeProject(Model m) {
        String version;
        String groupId = m.getGroupId();
        if (groupId == null && m.getParent() != null) {
            groupId = m.getParent().getGroupId();
        }
        if ((version = m.getVersion()) == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return new RelativeProject(groupId, m.getArtifactId(), version);
    }

    private static String toVersion(Model m) {
        String version = m.getVersion();
        if (version == null && m.getParent() != null) {
            version = m.getParent().getVersion();
        }
        return version;
    }
}

