/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.maven.model.building.AbstractModelSourceTransformer;
import org.apache.maven.model.building.DefaultBuildPomXMLFilterFactory;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.xml.sax.filter.AbstractSAXFilter;
import org.apache.maven.xml.sax.filter.BuildPomXMLFilterListener;
import org.eclipse.sisu.Nullable;
import org.xml.sax.SAXException;

@Named
@Singleton
class BuildModelSourceTransformer
extends AbstractModelSourceTransformer {
    @Inject
    @Nullable
    private BuildPomXMLFilterListener xmlFilterListener;

    BuildModelSourceTransformer() {
    }

    @Override
    protected AbstractSAXFilter getSAXFilter(Path pomFile, TransformerContext context) throws TransformerConfigurationException, SAXException, ParserConfigurationException {
        DefaultBuildPomXMLFilterFactory buildPomXMLFilterFactory = new DefaultBuildPomXMLFilterFactory(context);
        return buildPomXMLFilterFactory.get(pomFile);
    }

    @Override
    protected OutputStream filterOutputStream(OutputStream outputStream, final Path pomFile) {
        OutputStream out = this.xmlFilterListener != null ? new FilterOutputStream(outputStream){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                BuildModelSourceTransformer.this.xmlFilterListener.write(pomFile, b, off, len);
            }
        } : outputStream;
        return out;
    }
}

