/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.model.building.ModelSourceTransformer;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.building.TransformerException;
import org.apache.maven.xml.Factories;
import org.apache.maven.xml.sax.ext.CommentRenormalizer;
import org.apache.maven.xml.sax.filter.AbstractSAXFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractModelSourceTransformer
implements ModelSourceTransformer {
    private static final AtomicInteger TRANSFORM_THREAD_COUNTER = new AtomicInteger();
    private final TransformerFactory transformerFactory = Factories.newTransformerFactory();

    protected abstract AbstractSAXFilter getSAXFilter(Path var1, TransformerContext var2) throws TransformerConfigurationException, SAXException, ParserConfigurationException;

    protected OutputStream filterOutputStream(OutputStream outputStream, Path pomFile) {
        return outputStream;
    }

    protected TransformerHandler getTransformerHandler(Path pomFile) throws IOException, TransformerException {
        return null;
    }

    @Override
    public final InputStream transform(Path pomFile, TransformerContext context) throws IOException, TransformerException {
        Result result;
        AbstractSAXFilter filter;
        TransformerHandler transformerHandler = this.getTransformerHandler(pomFile);
        try {
            filter = this.getSAXFilter(pomFile, context);
            filter.setLexicalHandler((LexicalHandler)transformerHandler);
        }
        catch (ParserConfigurationException | TransformerConfigurationException | SAXException e) {
            throw new TransformerException(e);
        }
        SAXSource transformSource = new SAXSource((XMLReader)filter, new InputSource(new FileInputStream(pomFile.toFile())));
        PipedOutputStream pout = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pout);
        OutputStream out = this.filterOutputStream(pout, pomFile);
        if (transformerHandler == null) {
            result = new StreamResult(out);
        } else {
            result = new SAXResult(transformerHandler);
            ((SAXResult)result).setLexicalHandler((LexicalHandler)new CommentRenormalizer((LexicalHandler)transformerHandler));
            transformerHandler.setResult(new StreamResult(out));
        }
        IOExceptionHandler eh = new IOExceptionHandler();
        Thread transformThread = new Thread(() -> {
            try (PipedOutputStream pos = pout;){
                this.transformerFactory.newTransformer().transform(transformSource, result);
            }
            catch (IOException | javax.xml.transform.TransformerException e) {
                eh.uncaughtException(Thread.currentThread(), e);
            }
        }, "TransformThread-" + TRANSFORM_THREAD_COUNTER.incrementAndGet());
        transformThread.setUncaughtExceptionHandler(eh);
        transformThread.setDaemon(true);
        transformThread.start();
        return new ThreadAwareInputStream(pipedInputStream, eh);
    }

    private class ThreadAwareInputStream
    extends FilterInputStream {
        final IOExceptionHandler h;

        protected ThreadAwareInputStream(InputStream in, IOExceptionHandler h) {
            super(in);
            this.h = h;
        }

        @Override
        public void close() throws IOException {
            try (IOExceptionHandler eh = this.h;){
                super.close();
            }
        }
    }

    private static class IOExceptionHandler
    implements Thread.UncaughtExceptionHandler,
    AutoCloseable {
        private volatile Throwable cause;

        private IOExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            try {
                throw e;
            }
            catch (IOException | Error | RuntimeException | javax.xml.transform.TransformerException allGood) {
                this.cause = e;
            }
            catch (Throwable notGood) {
                throw new AssertionError("Unexpected Exception", e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.cause != null) {
                try {
                    throw this.cause;
                }
                catch (IOException | Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to transform pom", t);
                }
            }
        }
    }
}

