/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelValidator.class)
public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    @Override
    public void validateRawModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent = model.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("parent.groupId", problems, false, parent.getGroupId());
            this.validateStringNotEmpty("parent.artifactId", problems, false, parent.getArtifactId());
            this.validateStringNotEmpty("parent.version", problems, false, parent.getVersion());
            if (parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
                this.addViolation(problems, false, "The parent element cannot have the same ID as the project.");
            }
        }
        if (request.getValidationLevel() >= 20) {
            this.validateStringNoExpression("groupId", problems, true, model.getGroupId());
            this.validateStringNoExpression("artifactId", problems, true, model.getArtifactId());
            this.validateStringNoExpression("version", problems, true, model.getVersion());
            this.validateDependencies(problems, model.getDependencies(), "dependencies.dependency", request);
            if (model.getDependencyManagement() != null) {
                this.validateDependencies(problems, model.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency", request);
            }
            this.validateRepositories(problems, model.getRepositories(), "repositories.repository", request);
            this.validateRepositories(problems, model.getPluginRepositories(), "pluginRepositories.pluginRepository", request);
            for (Profile profile : model.getProfiles()) {
                this.validateDependencies(problems, profile.getDependencies(), "profiles.profile[" + profile.getId() + "].dependencies.dependency", request);
                if (profile.getDependencyManagement() != null) {
                    this.validateDependencies(problems, profile.getDependencyManagement().getDependencies(), "profiles.profile[" + profile.getId() + "].dependencyManagement.dependencies.dependency", request);
                }
                this.validateRepositories(problems, profile.getRepositories(), "profiles.profile[" + profile.getId() + "].repositories.repository", request);
                this.validateRepositories(problems, profile.getPluginRepositories(), "profiles.profile[" + profile.getId() + "].pluginRepositories.pluginRepository", request);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent;
        this.validateStringNotEmpty("modelVersion", problems, false, model.getModelVersion());
        this.validateId("groupId", problems, model.getGroupId());
        this.validateId("artifactId", problems, model.getArtifactId());
        this.validateStringNotEmpty("packaging", problems, false, model.getPackaging());
        if (!model.getModules().isEmpty() && !"pom".equals(model.getPackaging())) {
            this.addViolation(problems, false, "Packaging '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
        }
        if ((parent = model.getParent()) != null && parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
            this.addViolation(problems, false, "The parent element cannot have the same ID as the project.");
        }
        this.validateStringNotEmpty("version", problems, false, model.getVersion());
        boolean warnOnBadBoolean = request.getValidationLevel() < 30;
        for (Dependency d : model.getDependencies()) {
            this.validateId("dependencies.dependency.artifactId", problems, d.getArtifactId());
            this.validateId("dependencies.dependency.groupId", problems, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", problems, false, d.getType(), d.getManagementKey());
            this.validateStringNotEmpty("dependencies.dependency.version", problems, false, d.getVersion(), d.getManagementKey());
            if ("system".equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty((String)systemPath)) {
                    this.addViolation(problems, false, "For dependency " + d + ": system-scoped dependency must specify systemPath.");
                } else if (!new File(systemPath).isAbsolute()) {
                    this.addViolation(problems, false, "For dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                }
            } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
                this.addViolation(problems, false, "For dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
            if (request.getValidationLevel() < 20) continue;
            this.validateBoolean("dependencies.dependency.optional", problems, warnOnBadBoolean, d.getOptional(), d.getManagementKey());
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency d : mgmt.getDependencies()) {
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", problems, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", problems, d.getGroupId());
                if ("system".equals(d.getScope())) {
                    String systemPath = d.getSystemPath();
                    if (StringUtils.isEmpty((String)systemPath)) {
                        this.addViolation(problems, false, "For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                    } else if (!new File(systemPath).isAbsolute()) {
                        this.addViolation(problems, false, "For managed dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                    }
                } else if (StringUtils.isNotEmpty((String)d.getSystemPath())) {
                    this.addViolation(problems, false, "For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
                }
                if (request.getValidationLevel() < 20) continue;
                this.validateBoolean("dependencyManagement.dependencies.dependency.optional", problems, warnOnBadBoolean, d.getOptional(), d.getManagementKey());
            }
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            boolean warnOnMissingPluginVersion = request.getValidationLevel() < 31;
            Build build = model.getBuild();
            if (build != null) {
                for (Plugin p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, false, p.getArtifactId());
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, false, p.getGroupId());
                    this.validateStringNotEmpty("build.plugins.plugin.version", problems, warnOnMissingPluginVersion, p.getVersion(), p.getKey());
                    this.validateBoolean("build.plugins.plugin.inherited", problems, warnOnBadBoolean, p.getInherited(), p.getKey());
                    this.validateBoolean("build.plugins.plugin.extensions", problems, warnOnBadBoolean, p.getExtensions(), p.getKey());
                }
                this.validateResources(problems, build.getResources(), "build.resources.resource", request);
                this.validateResources(problems, build.getTestResources(), "build.testResources.testResource", request);
            }
            if ((reporting = model.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, false, p.getArtifactId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, false, p.getGroupId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.version", problems, warnOnMissingPluginVersion, p.getVersion(), p.getKey());
                }
            }
            this.forcePluginExecutionIdCollision(model, problems);
        }
    }

    private boolean validateId(String fieldName, ModelProblemCollector problems, String id) {
        if (!this.validateStringNotEmpty(fieldName, problems, false, id)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            this.addViolation(problems, false, "'" + fieldName + "' with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key = dependency.getManagementKey();
            if ("pom".equals(dependency.getType()) && "import".equals(dependency.getScope()) && StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                this.addViolation(problems, false, "'" + prefix + ".classifier' must be empty for imported POM: " + key);
            }
            if ((existing = (Dependency)index.get(key)) != null) {
                boolean warning = request.getValidationLevel() < 30;
                this.addViolation(problems, warning, "'" + prefix + ".(groupId:artifactId:type:classifier)' must be unique: " + key + " -> " + existing.getVersion() + " vs " + dependency.getVersion());
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validateRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix + ".id", problems, false, repository.getId());
            this.validateStringNotEmpty(prefix + "[" + repository.getId() + "].url", problems, false, repository.getUrl());
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                boolean warning = request.getValidationLevel() < 30;
                this.addViolation(problems, warning, "'" + prefix + ".id' must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl());
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validateResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        boolean warnOnBadBoolean = request.getValidationLevel() < 30;
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix + ".directory", problems, false, resource.getDirectory());
            this.validateBoolean(prefix + ".filtering", problems, warnOnBadBoolean, resource.getFiltering(), resource.getDirectory());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelProblemCollector problems) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    this.addViolation(problems, false, collisionException.getMessage());
                }
            }
        }
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, boolean warning, String string) {
        if (!this.hasExpression(string)) {
            return true;
        }
        this.addViolation(problems, warning, "'" + fieldName + "' contains an expression but should be a constant.");
        return false;
    }

    private boolean hasExpression(String value) {
        return value != null && value.indexOf("${") >= 0;
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, boolean warning, String string) {
        return this.validateStringNotEmpty(fieldName, problems, warning, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, boolean warning, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, problems, warning, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            this.addViolation(problems, warning, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            this.addViolation(problems, warning, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelProblemCollector problems, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, problems, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        this.addViolation(problems, false, "In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelProblemCollector problems, boolean warning, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            this.addViolation(problems, warning, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            this.addViolation(problems, warning, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelProblemCollector problems, Object object) {
        if (object != null) {
            return true;
        }
        this.addViolation(problems, false, "In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateBoolean(String fieldName, ModelProblemCollector problems, boolean warning, String string, String sourceHint) {
        if (string == null || string.length() <= 0) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        if (sourceHint != null) {
            this.addViolation(problems, warning, "'" + fieldName + "' must be 'true' or 'false' for " + sourceHint);
        } else {
            this.addViolation(problems, warning, "'" + fieldName + "' must be 'true' or 'false'.");
        }
        return false;
    }

    private void addViolation(ModelProblemCollector problems, boolean warning, String message) {
        if (warning) {
            problems.addWarning(message);
        } else {
            problems.addError(message);
        }
    }
}

