/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationException;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProfileActivator.class, hint="jdk-version")
public class JdkVersionProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        String jdk;
        boolean active = false;
        Activation activation = profile.getActivation();
        if (activation != null && (jdk = activation.getJdk()) != null) {
            String version = context.getSystemProperties().getProperty("java.version", "");
            if (version.length() <= 0) {
                throw new ProfileActivationException("Failed to determine Java version for profile " + profile.getId(), profile);
            }
            active = jdk.startsWith("!") ? !version.startsWith(jdk.substring(1)) : (JdkVersionProfileActivator.isRange(jdk) ? JdkVersionProfileActivator.isInRange(version, JdkVersionProfileActivator.getRange(jdk)) : version.startsWith(jdk));
        }
        return active;
    }

    private static boolean isInRange(String value, List<RangeValue> range) {
        int leftRelation = JdkVersionProfileActivator.getRelationOrder(value, range.get(0), true);
        if (leftRelation == 0) {
            return true;
        }
        if (leftRelation < 0) {
            return false;
        }
        return JdkVersionProfileActivator.getRelationOrder(value, range.get(1), false) <= 0;
    }

    private static int getRelationOrder(String value, RangeValue rangeValue, boolean isLeft) {
        if (rangeValue.value.length() <= 0) {
            return isLeft ? 1 : -1;
        }
        ArrayList<String> valueTokens = new ArrayList<String>(Arrays.asList(value.split("\\.")));
        ArrayList<String> rangeValueTokens = new ArrayList<String>(Arrays.asList(rangeValue.value.split("\\.")));
        int max = Math.max(valueTokens.size(), rangeValueTokens.size());
        JdkVersionProfileActivator.addZeroTokens(valueTokens, max);
        JdkVersionProfileActivator.addZeroTokens(rangeValueTokens, max);
        if (value.equals(rangeValue.getValue())) {
            if (!rangeValue.isClosed()) {
                return isLeft ? -1 : 1;
            }
            return 0;
        }
        for (int i = 0; i < valueTokens.size(); ++i) {
            int y;
            int x = Integer.parseInt((String)valueTokens.get(i));
            if (x < (y = Integer.parseInt((String)rangeValueTokens.get(i)))) {
                return -1;
            }
            if (x <= y) continue;
            return 1;
        }
        if (!rangeValue.isClosed()) {
            return isLeft ? -1 : 1;
        }
        return 0;
    }

    private static void addZeroTokens(List<String> tokens, int max) {
        if (tokens.size() < max) {
            for (int i = 0; i < max - tokens.size(); ++i) {
                tokens.add("0");
            }
        }
    }

    private static boolean isRange(String value) {
        return value.startsWith("[") || value.startsWith("(");
    }

    private static List<RangeValue> getRange(String range) {
        ArrayList<RangeValue> ranges = new ArrayList<RangeValue>();
        for (String token : range.split(",")) {
            if (token.startsWith("[")) {
                ranges.add(new RangeValue(token.replace("[", ""), true));
                continue;
            }
            if (token.startsWith("(")) {
                ranges.add(new RangeValue(token.replace("(", ""), false));
                continue;
            }
            if (token.endsWith("]")) {
                ranges.add(new RangeValue(token.replace("]", ""), true));
                continue;
            }
            if (token.endsWith(")")) {
                ranges.add(new RangeValue(token.replace(")", ""), false));
                continue;
            }
            if (token.length() > 0) continue;
            ranges.add(new RangeValue("", false));
        }
        if (ranges.size() < 2) {
            ranges.add(new RangeValue("99999999", false));
        }
        return ranges;
    }

    private static class RangeValue {
        private String value;
        private boolean isClosed;

        RangeValue(String value, boolean isClosed) {
            this.value = value.trim();
            this.isClosed = isClosed;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public String toString() {
            return this.value;
        }
    }
}

