/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelReader.class)
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input, Map<String, Object> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input file missing");
        }
        Model model = this.read((Reader)ReaderFactory.newXmlReader((File)input), options);
        model.setPomFile(input);
        return model;
    }

    @Override
    public Model read(Reader input, Map<String, Object> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input reader missing");
        }
        try {
            MavenXpp3Reader r = new MavenXpp3Reader();
            Model model = r.read(input, this.isStrict(options));
            return model;
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close((Reader)input);
        }
    }

    @Override
    public Model read(InputStream input, Map<String, Object> options) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream missing");
        }
        try {
            MavenXpp3Reader r = new MavenXpp3Reader();
            Model model = r.read(input, this.isStrict(options));
            return model;
        }
        catch (XmlPullParserException e) {
            throw new ModelParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        finally {
            IOUtil.close((InputStream)input);
        }
    }

    private boolean isStrict(Map<String, Object> options) {
        Object value = options != null ? options.get("org.apache.maven.model.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

