/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

public class ModelProblem {
    private String source;
    private String message;
    private Exception exception;
    private Severity severity;

    public ModelProblem(String message, Severity severity, String source) {
        this.message = message;
        this.severity = severity != null ? severity : Severity.ERROR;
        this.source = source != null ? source : "";
    }

    public ModelProblem(String message, Severity severity, String source, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : Severity.ERROR;
        this.source = source != null ? source : "";
        this.exception = exception;
    }

    public String getSource() {
        return this.source;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "";
            }
        }
        return msg;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("[").append((Object)this.getSeverity()).append("] ");
        buffer.append(this.getSource()).append(": ").append(this.getMessage());
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        FATAL,
        ERROR,
        WARNING;

    }
}

