/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.validation.ModelValidationResult;
import org.apache.maven.model.validation.ModelValidator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelValidator.class)
public class DefaultModelValidator
implements ModelValidator {
    private static final String ID_REGEX = "[A-Za-z0-9_\\-.]+";

    @Override
    public ModelValidationResult validateRawModel(Model model, ModelBuildingRequest request) {
        ModelValidationResult result = new ModelValidationResult();
        Parent parent = model.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("parent.groupId", result, false, parent.getGroupId());
            this.validateStringNotEmpty("parent.artifactId", result, false, parent.getArtifactId());
            this.validateStringNotEmpty("parent.version", result, false, parent.getVersion());
            if (parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
                this.addViolation(result, false, "The parent element cannot have the same ID as the project.");
            }
        }
        if (request.getValidationLevel() >= 20) {
            this.validateDependencies(result, model.getDependencies(), "dependencies", request);
            if (model.getDependencyManagement() != null) {
                this.validateDependencies(result, model.getDependencyManagement().getDependencies(), "dependencyManagment.dependencies", request);
            }
            this.validateRepositories(result, model.getRepositories(), "repositories.repository", request);
            this.validateRepositories(result, model.getPluginRepositories(), "pluginRepositories.pluginRepository", request);
            for (Profile profile : model.getProfiles()) {
                this.validateDependencies(result, profile.getDependencies(), "profiles.profile[" + profile.getId() + "].dependencies", request);
                if (profile.getDependencyManagement() != null) {
                    this.validateDependencies(result, profile.getDependencyManagement().getDependencies(), "profiles.profile[" + profile.getId() + "].dependencyManagment.dependencies", request);
                }
                this.validateRepositories(result, profile.getRepositories(), "profiles.profile[" + profile.getId() + "].repositories.repository", request);
                this.validateRepositories(result, profile.getPluginRepositories(), "profiles.profile[" + profile.getId() + "].pluginRepositories.pluginRepository", request);
            }
        }
        return result;
    }

    @Override
    public ModelValidationResult validateEffectiveModel(Model model, ModelBuildingRequest request) {
        Parent parent;
        ModelValidationResult result = new ModelValidationResult();
        this.validateStringNotEmpty("modelVersion", result, false, model.getModelVersion());
        this.validateId("groupId", result, model.getGroupId());
        this.validateId("artifactId", result, model.getArtifactId());
        this.validateStringNotEmpty("packaging", result, false, model.getPackaging());
        if (!model.getModules().isEmpty() && !"pom".equals(model.getPackaging())) {
            this.addViolation(result, false, "Packaging '" + model.getPackaging() + "' is invalid. Aggregator projects " + "require 'pom' as packaging.");
        }
        if ((parent = model.getParent()) != null && parent.getGroupId().equals(model.getGroupId()) && parent.getArtifactId().equals(model.getArtifactId())) {
            this.addViolation(result, false, "The parent element cannot have the same ID as the project.");
        }
        this.validateStringNotEmpty("version", result, false, model.getVersion());
        for (Dependency d : model.getDependencies()) {
            this.validateId("dependencies.dependency.artifactId", result, d.getArtifactId());
            this.validateId("dependencies.dependency.groupId", result, d.getGroupId());
            this.validateStringNotEmpty("dependencies.dependency.type", result, false, d.getType(), d.getManagementKey());
            this.validateStringNotEmpty("dependencies.dependency.version", result, false, d.getVersion(), d.getManagementKey());
            if ("system".equals(d.getScope())) {
                String systemPath = d.getSystemPath();
                if (StringUtils.isEmpty((String)systemPath)) {
                    this.addViolation(result, false, "For dependency " + d + ": system-scoped dependency must specify systemPath.");
                    continue;
                }
                if (new File(systemPath).isAbsolute()) continue;
                this.addViolation(result, false, "For dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                continue;
            }
            if (!StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
            this.addViolation(result, false, "For dependency " + d + ": only dependency with system scope can specify systemPath.");
        }
        DependencyManagement mgmt = model.getDependencyManagement();
        if (mgmt != null) {
            for (Dependency d : mgmt.getDependencies()) {
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.artifactId", result, d.getArtifactId());
                this.validateSubElementStringNotEmpty(d, "dependencyManagement.dependencies.dependency.groupId", result, d.getGroupId());
                if ("system".equals(d.getScope())) {
                    String systemPath = d.getSystemPath();
                    if (StringUtils.isEmpty((String)systemPath)) {
                        this.addViolation(result, false, "For managed dependency " + d + ": system-scoped dependency must specify systemPath.");
                        continue;
                    }
                    if (new File(systemPath).isAbsolute()) continue;
                    this.addViolation(result, false, "For managed dependency " + d + ": system-scoped dependency must " + "specify an absolute path systemPath.");
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)d.getSystemPath())) continue;
                this.addViolation(result, false, "For managed dependency " + d + ": only dependency with system scope can specify systemPath.");
            }
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            boolean warnOnMissingPluginVersion = request.getValidationLevel() < 31;
            Build build = model.getBuild();
            if (build != null) {
                for (Plugin p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", result, false, p.getArtifactId());
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", result, false, p.getGroupId());
                    this.validateStringNotEmpty("build.plugins.plugin.version", result, warnOnMissingPluginVersion, p.getVersion(), p.getKey());
                }
                this.validateResources(result, build.getResources(), "build.resources.resource");
                this.validateResources(result, build.getTestResources(), "build.testResources.testResource");
            }
            if ((reporting = model.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", result, false, p.getArtifactId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", result, false, p.getGroupId());
                    this.validateStringNotEmpty("reporting.plugins.plugin.version", result, warnOnMissingPluginVersion, p.getVersion(), p.getKey());
                }
            }
            this.forcePluginExecutionIdCollision(model, result);
        }
        return result;
    }

    private boolean validateId(String fieldName, ModelValidationResult result, String id) {
        if (!this.validateStringNotEmpty(fieldName, result, false, id)) {
            return false;
        }
        boolean match = id.matches(ID_REGEX);
        if (!match) {
            this.addViolation(result, false, "'" + fieldName + "' with value '" + id + "' does not match a valid id pattern.");
        }
        return match;
    }

    private void validateDependencies(ModelValidationResult result, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            String key = dependency.getManagementKey();
            Dependency existing = (Dependency)index.get(key);
            if (existing != null) {
                boolean warning = request.getValidationLevel() < 30;
                this.addViolation(result, warning, "'" + prefix + ".(groupId:artifactId:type:classifier)' must be unique: " + key + " -> " + existing.getVersion() + " vs " + dependency.getVersion());
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validateRepositories(ModelValidationResult result, List<Repository> repositories, String prefix, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateStringNotEmpty(prefix + ".id", result, false, repository.getId());
            this.validateStringNotEmpty(prefix + ".url", result, false, repository.getUrl());
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                boolean warning = request.getValidationLevel() < 30;
                this.addViolation(result, warning, "'" + prefix + ".id' must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl());
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validateResources(ModelValidationResult result, List<Resource> resources, String prefix) {
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix + ".directory", result, false, resource.getDirectory());
        }
    }

    private void forcePluginExecutionIdCollision(Model model, ModelValidationResult result) {
        List plugins;
        Build build = model.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin plugin : plugins) {
                try {
                    plugin.getExecutionsAsMap();
                }
                catch (IllegalStateException collisionException) {
                    this.addViolation(result, false, collisionException.getMessage());
                }
            }
        }
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, boolean warning, String string) {
        return this.validateStringNotEmpty(fieldName, result, warning, string, null);
    }

    private boolean validateStringNotEmpty(String fieldName, ModelValidationResult result, boolean warning, String string, String sourceHint) {
        if (!this.validateNotNull(fieldName, result, warning, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        if (sourceHint != null) {
            this.addViolation(result, false, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            this.addViolation(result, false, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementStringNotEmpty(Object subElementInstance, String fieldName, ModelValidationResult result, String string) {
        if (!this.validateSubElementNotNull(subElementInstance, fieldName, result, string)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        this.addViolation(result, false, "In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private boolean validateNotNull(String fieldName, ModelValidationResult result, boolean warning, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        if (sourceHint != null) {
            this.addViolation(result, warning, "'" + fieldName + "' is missing for " + sourceHint);
        } else {
            this.addViolation(result, warning, "'" + fieldName + "' is missing.");
        }
        return false;
    }

    private boolean validateSubElementNotNull(Object subElementInstance, String fieldName, ModelValidationResult result, Object object) {
        if (object != null) {
            return true;
        }
        this.addViolation(result, false, "In " + subElementInstance + ":\n\n       -> '" + fieldName + "' is missing.");
        return false;
    }

    private void addViolation(ModelValidationResult result, boolean warning, String message) {
        if (warning) {
            result.addWarning(message);
        } else {
            result.addError(message);
        }
    }
}

