/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.management.ManagementInjector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManagementInjector.class)
public class DefaultManagementInjector
implements ManagementInjector {
    private ManagementModelMerger merger = new ManagementModelMerger();

    public void injectManagement(Model model, ModelBuildingRequest request) {
        this.merger.mergeManagedDependencies(model);
        this.merger.mergeManagedBuildPlugins(model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagementModelMerger
    extends MavenModelMerger {
        private ManagementModelMerger() {
        }

        public void mergeManagedBuildPlugins(Model model) {
            PluginManagement pluginManagement;
            Build build = model.getBuild();
            if (build != null && (pluginManagement = build.getPluginManagement()) != null) {
                this.mergePluginContainer_Plugins((PluginContainer)build, (PluginContainer)pluginManagement, false, Collections.<Object, Object>emptyMap());
            }
        }

        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> managedPlugins = new LinkedHashMap<Object, Plugin>(src.size() * 2);
                for (Plugin element : src) {
                    key = this.getPluginKey(element);
                    managedPlugins.put(key, element);
                }
                for (Plugin element : tgt) {
                    key = this.getPluginKey(element);
                    Plugin managedPlugin = (Plugin)managedPlugins.get(key);
                    if (managedPlugin == null) continue;
                    this.mergePlugin(element, managedPlugin, sourceDominant, context);
                }
            }
        }

        @Override
        protected void mergePlugin_Executions(Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getExecutions();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getExecutions();
                LinkedHashMap<Object, PluginExecution> merged = new LinkedHashMap<Object, PluginExecution>((src.size() + tgt.size()) * 2);
                for (PluginExecution element : src) {
                    key = this.getPluginExecutionKey(element);
                    PluginExecution clone = new PluginExecution();
                    this.mergePluginExecution(clone, element, true, context);
                    merged.put(key, clone);
                }
                for (PluginExecution element : tgt) {
                    key = this.getPluginExecutionKey(element);
                    PluginExecution existing = (PluginExecution)merged.get(key);
                    if (existing != null) {
                        this.mergePluginExecution(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                target.setExecutions(new ArrayList(merged.values()));
            }
        }

        public void mergeManagedDependencies(Model model) {
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            if (dependencyManagement != null) {
                Object key;
                HashMap<Object, Dependency> dependencies = new HashMap<Object, Dependency>();
                Map context = Collections.emptyMap();
                for (Dependency dependency : model.getDependencies()) {
                    key = this.getDependencyKey(dependency);
                    dependencies.put(key, dependency);
                }
                for (Dependency managedDependency : dependencyManagement.getDependencies()) {
                    key = this.getDependencyKey(managedDependency);
                    Dependency dependency = (Dependency)dependencies.get(key);
                    if (dependency == null) continue;
                    this.mergeDependency(dependency, managedDependency, false, context);
                }
            }
        }

        protected void mergeDependency_Exclusions(Dependency target, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
            List tgt = target.getExclusions();
            if (tgt.isEmpty()) {
                List src = source.getExclusions();
                for (Exclusion element : src) {
                    Exclusion clone = new Exclusion();
                    this.mergeExclusion(clone, element, true, context);
                    target.addExclusion(clone);
                }
            }
        }
    }
}

