/*
 * $Id$
 */

package org.apache.maven.lifecycle.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Specifies phase bindings for clean, site, and default
 * lifecycles.
 * 
 * @version $Revision$ $Date$
 */
public class LifecycleBindings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * POM packaging to which this lifecycle specification applies.
     */
    private String packaging;

    /**
     * The binding for the clean lifecycle.
     */
    private CleanBinding cleanBinding = new CleanBinding();

    /**
     * The binding for the main build (default) lifecycle.
     */
    private BuildBinding buildBinding = new BuildBinding();

    /**
     * The binding for the site lifecycle.
     */
    private SiteBinding siteBinding = new SiteBinding();


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the binding for the main build (default) lifecycle.
     * 
     * @return BuildBinding
     */
    public BuildBinding getBuildBinding()
    {
        return this.buildBinding;
    } //-- BuildBinding getBuildBinding() 

    /**
     * Get the binding for the clean lifecycle.
     * 
     * @return CleanBinding
     */
    public CleanBinding getCleanBinding()
    {
        return this.cleanBinding;
    } //-- CleanBinding getCleanBinding() 

    /**
     * Get pOM packaging to which this lifecycle specification
     * applies.
     * 
     * @return String
     */
    public String getPackaging()
    {
        return this.packaging;
    } //-- String getPackaging() 

    /**
     * Get the binding for the site lifecycle.
     * 
     * @return SiteBinding
     */
    public SiteBinding getSiteBinding()
    {
        return this.siteBinding;
    } //-- SiteBinding getSiteBinding() 

    /**
     * Set the binding for the main build (default) lifecycle.
     * 
     * @param buildBinding
     */
    public void setBuildBinding( BuildBinding buildBinding )
    {
        this.buildBinding = buildBinding;
    } //-- void setBuildBinding( BuildBinding ) 

    /**
     * Set the binding for the clean lifecycle.
     * 
     * @param cleanBinding
     */
    public void setCleanBinding( CleanBinding cleanBinding )
    {
        this.cleanBinding = cleanBinding;
    } //-- void setCleanBinding( CleanBinding ) 

    /**
     * Set pOM packaging to which this lifecycle specification
     * applies.
     * 
     * @param packaging
     */
    public void setPackaging( String packaging )
    {
        this.packaging = packaging;
    } //-- void setPackaging( String ) 

    /**
     * Set the binding for the site lifecycle.
     * 
     * @param siteBinding
     */
    public void setSiteBinding( SiteBinding siteBinding )
    {
        this.siteBinding = siteBinding;
    } //-- void setSiteBinding( SiteBinding ) 


    public java.util.List getBindingList()
    {
        java.util.List lifecycles = new java.util.ArrayList();
        
        if ( getCleanBinding() != null )
        {
            lifecycles.add( getCleanBinding() );
        }
        
        if ( getBuildBinding() != null )
        {
            lifecycles.add( getBuildBinding() );
        }
        
        if ( getSiteBinding() != null )
        {
            lifecycles.add( getSiteBinding() );
        }
        
        return java.util.Collections.unmodifiableList( lifecycles );
    }
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
